/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.layers;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openraven.magpie.api.MagpieEnvelope;
import io.openraven.magpie.api.MagpiePlugin;
import io.openraven.magpie.api.OriginPlugin;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.core.fifos.FifoException;
import io.openraven.magpie.core.fifos.FifoQueue;
import io.openraven.magpie.core.layers.Layer;
import io.openraven.magpie.core.layers.LayerType;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginLayer
implements Layer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginLayer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper ANNOTATED_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).findAndRegisterModules().activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    private final Session session;
    private final Collection<OriginPlugin> plugins;
    private final FifoQueue queue;
    private final String name;

    public OriginLayer(String name, Session session, Collection<OriginPlugin> plugins, FifoQueue queue) {
        this.session = session;
        this.plugins = plugins;
        this.queue = queue;
        this.name = name;
    }

    @Override
    public void exec() throws FifoException {
        this.plugins.forEach(p -> {
            try {
                LOGGER.trace("Running discover for plugin {}", (Object)p.id());
                p.discover(this.session, this::emit);
            }
            catch (Exception ex) {
                LOGGER.warn("Plugin exception: {}", (Object)p.id(), (Object)ex);
            }
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void emit(MagpieEnvelope env) {
        try {
            env.getContents().set("discoveryMeta", ANNOTATED_MAPPER.valueToTree((Object)this.session));
            env.getContents().set("discoverySessionId", MAPPER.valueToTree((Object)this.session.getId()));
            env.setSession(this.session);
            this.queue.add(env);
        }
        catch (FifoException e) {
            LOGGER.warn("Emitter exception", (Throwable)e);
        }
    }

    @Override
    public LayerType getType() {
        return LayerType.ORIGIN;
    }

    @Override
    public void shutdown() {
        this.plugins.forEach(MagpiePlugin::shutdown);
    }
}

