/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.fifos;

import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.config.FifoConfig;
import io.openraven.magpie.core.config.LayerConfig;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.fifos.FifoDequeue;
import io.openraven.magpie.core.fifos.FifoQueue;
import io.openraven.magpie.core.fifos.KafkaDequeue;
import io.openraven.magpie.core.fifos.KafkaQueue;
import io.openraven.magpie.core.fifos.LocalQueue;
import io.openraven.magpie.core.fifos.QueueType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FifoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FifoManager.class);
    private final Map<String, FifoQueue> queues = new HashMap<String, FifoQueue>();
    private final Map<String, FifoDequeue> dequeues = new HashMap<String, FifoDequeue>();
    private final MagpieConfig config;

    public FifoManager(MagpieConfig config) {
        this.config = config;
        List<String> buildQueues = config.getLayers().values().stream().map(LayerConfig::getQueue).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> buildDequeues = config.getLayers().values().stream().map(LayerConfig::getDequeue).filter(Objects::nonNull).collect(Collectors.toList());
        this.buildQueues(buildQueues);
        this.buildDequeues(buildDequeues);
    }

    private void buildQueues(List<String> buildQueues) {
        buildQueues.forEach(name -> {
            if (this.queues.containsKey(name)) {
                throw new ConfigException("Duplicate queue name: " + name);
            }
            FifoConfig fifoConfig = this.config.getFifos().get(name);
            if (fifoConfig == null) {
                throw new ConfigException("No fifo definition found for " + name);
            }
            QueueType queueType = QueueType.valueOf(fifoConfig.getType().toUpperCase());
            switch (queueType) {
                case LOCAL: {
                    LocalQueue q = new LocalQueue();
                    this.queues.put((String)name, q);
                    this.dequeues.put((String)name, q);
                    break;
                }
                case KAFKA: {
                    KafkaQueue qk = new KafkaQueue(fifoConfig.getProperties());
                    this.queues.put((String)name, qk);
                    break;
                }
                default: {
                    throw new ConfigException("Invalid queue type: " + queueType);
                }
            }
            LOGGER.debug("Created {}:{}", name, (Object)queueType);
        });
    }

    private void buildDequeues(List<String> buildDequeues) {
        buildDequeues.stream().filter(name -> !this.dequeues.containsKey(name)).forEach(name -> {
            FifoConfig fifoConfig = this.config.getFifos().get(name);
            if (fifoConfig == null) {
                throw new ConfigException("No fifo definition found for " + name);
            }
            QueueType queueType = QueueType.valueOf(fifoConfig.getType().toUpperCase());
            switch (queueType) {
                case LOCAL: {
                    break;
                }
                case KAFKA: {
                    KafkaDequeue dk = new KafkaDequeue(fifoConfig.getProperties());
                    this.dequeues.put((String)name, dk);
                    break;
                }
                default: {
                    throw new ConfigException("Invalid queue type: " + queueType);
                }
            }
        });
    }

    public FifoQueue getQueue(String name) {
        return this.queues.get(name);
    }

    public FifoDequeue getDequeue(String name) {
        return this.dequeues.get(name);
    }
}

