/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.dmap.service;

import io.openraven.magpie.core.dmap.client.dto.AppProbability;
import io.openraven.magpie.core.dmap.dto.DMapScanResult;
import io.openraven.magpie.core.dmap.service.DMapReportService;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class DMapReportServiceImpl
implements DMapReportService {
    private static final double PROBABILITY_THRESHOLD = 0.5;
    private static final String BOLD_SET = "\u001b[1m";
    private static final String BOLD_RESET = "\u001b[0m";
    private static final int SERVICE_COLUMN_WIDTH = 23;
    private static final int IP_COLUMN_WIDTH = 18;
    private static final int REGION_COLUMN_WIDTH = 13;
    private static final int PORT_COLUMN_WIDTH = 9;
    private static final int PROBABILITY_COLUMN_WIDTH = 14;
    private static final int APP_COLUMN_WIDTH = 15;

    @Override
    public void generateReport(DMapScanResult dMapScanResult) {
        System.out.println("\u001b[1mDMap Summary:\u001b[0m");
        System.out.printf("%-30s%-40s\n", "DMap start time", dMapScanResult.getStartDateTime().toString());
        System.out.printf("%-30s%-40s\n\n", "DMap duration", this.humanReadableFormat(dMapScanResult.getDuration()));
        System.out.printf("\u001b[1m%-13s%-23s%-18s%-9s%-14s%-15s\n\u001b[0m", "Region", "Resource Id", "IP Address", "Port", "Probability", "App");
        dMapScanResult.getFingerprintAnalyses().forEach(fingerprintAnalysis -> {
            System.out.printf("%-13s%-23s%-18s", fingerprintAnalysis.getRegion(), fingerprintAnalysis.getResourceId(), fingerprintAnalysis.getAddress());
            if (fingerprintAnalysis.getPredictionsByPort().isEmpty()) {
                System.out.printf("%-9s%-14s%-15s\n", "--", "--", "No open ports");
            } else {
                System.out.println("");
            }
            new TreeMap<Integer, List<AppProbability>>(fingerprintAnalysis.getPredictionsByPort()).forEach((port, probabilities) -> this.findTop((List<AppProbability>)probabilities).ifPresent(app -> System.out.printf("%-54s%-9s%-14.2f%-4s\n", "", port, app.getProbability(), app.getAppName())));
        });
    }

    private Optional<AppProbability> findTop(List<AppProbability> appProbabilityList) {
        return appProbabilityList.stream().filter(appProbability -> appProbability.getProbability() > 0.5).sorted().findFirst();
    }

    private String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }
}

