/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.layers;

import io.openraven.magpie.api.IntermediatePlugin;
import io.openraven.magpie.api.OriginPlugin;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.api.TerminalPlugin;
import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.config.LayerConfig;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.fifos.FifoDequeue;
import io.openraven.magpie.core.fifos.FifoManager;
import io.openraven.magpie.core.fifos.FifoQueue;
import io.openraven.magpie.core.layers.IntermediateLayer;
import io.openraven.magpie.core.layers.Layer;
import io.openraven.magpie.core.layers.LayerType;
import io.openraven.magpie.core.layers.OriginLayer;
import io.openraven.magpie.core.layers.TerminalLayer;
import io.openraven.magpie.core.plugins.PluginManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayerManager.class);
    private final MagpieConfig config;
    private final FifoManager fifoManager;
    private final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();

    public LayerManager(Session session, MagpieConfig config, FifoManager fifoManager, PluginManager pluginManager) {
        this.config = config;
        this.fifoManager = fifoManager;
        this.buildLayers(session, fifoManager, pluginManager);
    }

    private void buildLayers(Session session, FifoManager fifoManager, PluginManager pluginManager) {
        this.config.getLayers().forEach((name, layerConfig) -> {
            List plugins = layerConfig.getPlugins().stream().map(pluginManager::byId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            LayerType layerType = LayerType.valueOf(layerConfig.getType().toUpperCase());
            switch (layerType) {
                case ORIGIN: {
                    this.layers.put((String)name, new OriginLayer((String)name, session, plugins.stream().map(p -> (OriginPlugin)p).collect(Collectors.toList()), this.getOrThrowQueue((String)name, (LayerConfig)layerConfig)));
                    break;
                }
                case INTERMEDIATE: {
                    this.layers.put((String)name, new IntermediateLayer((String)name, this.getOrThrowDequeue((String)name, (LayerConfig)layerConfig), plugins.stream().map(p -> (IntermediatePlugin)p).collect(Collectors.toList()), this.getOrThrowQueue((String)name, (LayerConfig)layerConfig)));
                    break;
                }
                case TERMINAL: {
                    this.layers.put((String)name, new TerminalLayer((String)name, this.getOrThrowDequeue((String)name, (LayerConfig)layerConfig), plugins.stream().map(p -> (TerminalPlugin)p).collect(Collectors.toList())));
                    break;
                }
                default: {
                    throw new ConfigException(String.format("Illegal type for layer %s: %s", name, layerConfig.getType()));
                }
            }
            LOGGER.debug("Built layer {}", name);
        });
    }

    private FifoQueue getOrThrowQueue(String layerName, LayerConfig layerConfig) {
        String queueName = layerConfig.getQueue();
        if (Objects.isNull(queueName)) {
            throw new ConfigException("No fifo queue defined for " + layerName);
        }
        FifoQueue queue = this.fifoManager.getQueue(queueName);
        if (Objects.isNull(queue)) {
            throw new ConfigException("Couldn't find queue " + queueName);
        }
        return queue;
    }

    private FifoDequeue getOrThrowDequeue(String layerName, LayerConfig layerConfig) {
        String dequeueName = layerConfig.getDequeue();
        if (Objects.isNull(dequeueName)) {
            throw new ConfigException("No fifo dequeue defined for " + layerName);
        }
        FifoDequeue dequeue = this.fifoManager.getDequeue(dequeueName);
        if (Objects.isNull(dequeue)) {
            throw new ConfigException("Couldn't find dequeue " + dequeueName);
        }
        return dequeue;
    }

    public Map<String, Layer> getLayers() {
        return Collections.unmodifiableMap(this.layers);
    }
}

