/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.dmap.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.dmap.client.DMapMLClient;
import io.openraven.magpie.core.dmap.client.dto.AppProbability;
import io.openraven.magpie.core.dmap.client.dto.DMapMLRequest;
import io.openraven.magpie.core.dmap.client.dto.DMapMLResponse;
import io.openraven.magpie.core.dmap.exception.DMapClientException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMapMLClientImpl
implements DMapMLClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DMapMLClientImpl.class);
    private static final String DMAP_ML_PROP_NAME = "openraven.dmap.ml";
    private final String dmapMLServiceURL;
    private final ObjectMapper mapper;

    public DMapMLClientImpl(ObjectMapper mapper, MagpieConfig config) {
        this.mapper = mapper;
        this.dmapMLServiceURL = this.getDmapMlUrl(config);
    }

    @Override
    public List<AppProbability> predict(Map<String, String> signature) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.dmapMLServiceURL)).POST(HttpRequest.BodyPublishers.ofString(this.getRequestBody(signature))).header("Content-Type", "application/json").build();
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            DMapMLResponse dMapMLResponse = (DMapMLResponse)this.mapper.readValue(response.body(), DMapMLResponse.class);
            return dMapMLResponse.getPredictions();
        }
        catch (Exception e) {
            LOGGER.error("Unable to send request to OpenRaven DMAP ML service", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getRequestBody(Map<String, String> signature) {
        DMapMLRequest dMapMLRequest = new DMapMLRequest();
        dMapMLRequest.setSignature(signature);
        try {
            return this.mapper.writeValueAsString((Object)dMapMLRequest);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unable to serialize DMap ML request body: {}", (Object)dMapMLRequest, (Object)e);
            throw new DMapClientException("DMap response deserialization failed", e);
        }
    }

    private String getDmapMlUrl(MagpieConfig config) {
        return config.getServices().get(DMAP_ML_PROP_NAME).getUrl();
    }
}

