/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.layers;

import io.openraven.magpie.api.MagpieEnvelope;
import io.openraven.magpie.api.MagpiePlugin;
import io.openraven.magpie.api.TerminalPlugin;
import io.openraven.magpie.core.fifos.FifoDequeue;
import io.openraven.magpie.core.fifos.FifoException;
import io.openraven.magpie.core.layers.Layer;
import io.openraven.magpie.core.layers.LayerType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalLayer
implements Layer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalLayer.class);
    private final FifoDequeue dequeue;
    private final Collection<TerminalPlugin> plugins;
    private final String name;

    public TerminalLayer(String name, FifoDequeue dequeue, Collection<TerminalPlugin> plugins) {
        this.dequeue = dequeue;
        this.plugins = plugins;
        this.name = name;
    }

    @Override
    public void exec() throws FifoException {
        Optional<MagpieEnvelope> opt = this.dequeue.poll();
        if (opt.isEmpty()) {
            return;
        }
        MagpieEnvelope env = opt.get();
        List pluginPath = env.getPluginPath();
        String lastPlugin = pluginPath.isEmpty() ? null : (String)pluginPath.get(pluginPath.size() - 1);
        this.plugins.forEach(p -> {
            try {
                p.accept(env);
            }
            catch (Exception ex) {
                LOGGER.warn("Plugin exception: {}", (Object)p.id(), (Object)ex);
            }
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LayerType getType() {
        return LayerType.TERMINAL;
    }

    @Override
    public void shutdown() {
        this.plugins.forEach(MagpiePlugin::shutdown);
    }
}

