/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.dmap.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.config.PluginConfig;
import io.openraven.magpie.core.dmap.Util;
import io.openraven.magpie.core.dmap.model.DMapTarget;
import io.openraven.magpie.core.dmap.model.EC2Target;
import io.openraven.magpie.core.dmap.model.VpcConfig;
import io.openraven.magpie.core.dmap.service.DMapAssetService;
import io.openraven.magpie.plugins.persist.AssetsRepo;
import io.openraven.magpie.plugins.persist.PersistConfig;
import io.openraven.magpie.plugins.persist.impl.HibernateAssetsRepoImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMapAssetServiceImpl
implements DMapAssetService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DMapAssetServiceImpl.class);
    private static final String QUERY = Util.getResourceAsString("/sql/dmap-asset-grouping.sql");
    private final ObjectMapper mapper = new ObjectMapper();
    private AssetsRepo assetsRepo;

    public DMapAssetServiceImpl(MagpieConfig config) {
        this.assetsRepo = this.initPersistence(config);
    }

    @Override
    public Map<VpcConfig, List<EC2Target>> groupScanTargets() {
        List maps = this.assetsRepo.queryNative(QUERY);
        List scanTargets = maps.stream().map(tuple -> new DMapTarget(tuple.get("resourceid").toString(), String.valueOf(tuple.get("region")), tuple.get("subnet_id").toString(), tuple.get("private_ip_address").toString(), List.of(tuple.get("security_group").toString().split(",")))).collect(Collectors.toList());
        LOGGER.debug("Retrieved EC2 assets from DB: {}", scanTargets);
        LOGGER.info("Total EC2 assets to scan: {}", (Object)scanTargets.size());
        return scanTargets.stream().collect(Collectors.groupingBy(dmapTarget -> new VpcConfig(dmapTarget.getRegion(), dmapTarget.getSubnetId(), dmapTarget.getSecurityGroups()), Collectors.mapping(dmapTarget -> new EC2Target(dmapTarget.getResourceId(), dmapTarget.getPrivateIpAddress()), Collectors.toList())));
    }

    private AssetsRepo initPersistence(MagpieConfig config) {
        PluginConfig rawPersistConfig = config.getPlugins().get("magpie.persist");
        if (rawPersistConfig == null) {
            throw new ConfigException(String.format("Config file does not contain %s configuration", "magpie.persist"));
        }
        try {
            PersistConfig persistConfig = (PersistConfig)this.mapper.treeToValue((TreeNode)this.mapper.valueToTree(rawPersistConfig.getConfig()), PersistConfig.class);
            return new HibernateAssetsRepoImpl(persistConfig);
        }
        catch (JsonProcessingException e) {
            throw new ConfigException("Cannot instantiate PersistConfig while initializing PolicyAnalyzerService", e);
        }
    }
}

