/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.fifos;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.openraven.magpie.api.MagpieEnvelope;
import io.openraven.magpie.core.config.ConfigException;
import io.openraven.magpie.core.fifos.FifoException;
import io.openraven.magpie.core.fifos.FifoQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaQueue
implements FifoQueue {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).findAndRegisterModules();
    private static final Map<String, Object> DEFAULT_PROPERTIES = Map.of("acks", "all", "key.serializer", StringSerializer.class.getName(), "value.serializer", StringSerializer.class.getName());
    private final Producer<String, String> producer;
    private final String topic;

    public KafkaQueue(Map<String, Object> properties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(DEFAULT_PROPERTIES);
        props.putAll(properties);
        Object t = props.remove("topic");
        if (Objects.isNull(t)) {
            throw new ConfigException("Kafka 'topic' value must be set under properties");
        }
        this.topic = t.toString();
        this.producer = new KafkaProducer(props);
    }

    @Override
    public void add(MagpieEnvelope env) throws FifoException {
        try {
            this.producer.send(new ProducerRecord(this.topic, (Object)MAPPER.writeValueAsString((Object)env)));
        }
        catch (JsonProcessingException ex) {
            throw new FifoException("Couldn't serialize envelope", ex);
        }
    }
}

