/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core.cspm.services;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.config.PluginConfig;
import io.openraven.magpie.core.config.PolicyConfig;
import io.openraven.magpie.core.cspm.model.Policy;
import io.openraven.magpie.core.cspm.model.PolicyContext;
import io.openraven.magpie.core.cspm.model.PolicyMetadata;
import io.openraven.magpie.core.cspm.model.Rule;
import io.openraven.magpie.core.cspm.services.PolicyAcquisitionService;
import io.openraven.magpie.plugins.persist.PersistConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyAcquisitionServiceImpl
implements PolicyAcquisitionService {
    private static final String SQL_SCHEMA_TOKEN = "\\$\\{magpie_schema\\}";
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyAcquisitionServiceImpl.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private PolicyConfig policyConfig;
    private MagpieConfig config;

    @Override
    public void init(MagpieConfig config) {
        this.policyConfig = config.getPolicies();
        this.config = config;
        this.policyConfig.getRepositories().stream().map(repository -> repository.replace("~", System.getProperty("user.home"))).forEach(repository -> {
            if (this.isGitRepository((String)repository)) {
                this.getGitRepository((String)repository);
            } else {
                this.copyLocalRepository((String)repository);
            }
        });
    }

    @Override
    public List<PolicyContext> loadPolicies() {
        if (this.policyConfig == null) {
            LOGGER.error("Class have to be initialized first!");
            return List.of();
        }
        ArrayList<PolicyContext> policyContexts = new ArrayList<PolicyContext>();
        this.policyConfig.getRepositories().stream().map(repository -> repository.replace("~", System.getProperty("user.home"))).forEach(repository -> {
            String repositoryPath = this.getTargetProjectDirectoryPath((String)repository).toString();
            ArrayList<PolicyContext> repositoryPolicies = this.loadPoliciesFromRepository(repositoryPath);
            policyContexts.addAll(repositoryPolicies);
        });
        return policyContexts;
    }

    private List<Rule> loadRules(String rulesDirectory, List<String> ruleFileNames) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        PluginConfig persistConfig = this.config.getPlugins().get("magpie.persist");
        String schema = ((PersistConfig)persistConfig.getConfig()).getSchema();
        for (String ruleFileName : ruleFileNames) {
            try {
                File ruleFile = new File(rulesDirectory + "/" + ruleFileName);
                Rule yamlRule = (Rule)YAML_MAPPER.readValue(ruleFile, Rule.class);
                yamlRule.setFileName(ruleFileName);
                if (yamlRule.getSql() != null) {
                    yamlRule.setSql(yamlRule.getSql().replaceAll(SQL_SCHEMA_TOKEN, schema));
                }
                rules.add(yamlRule);
                LOGGER.info("Successfully loaded rule {}", (Object)yamlRule.getRuleId());
            }
            catch (IOException yamlIOException) {
                LOGGER.error(yamlIOException.getMessage());
            }
        }
        return rules;
    }

    private ArrayList<PolicyContext> loadPoliciesFromRepository(String repositoryPath) {
        File policiesDirectory = new File(repositoryPath + "/policies");
        File rulesDirectory = new File(repositoryPath + "/rules");
        ArrayList<PolicyContext> policiesContexts = new ArrayList<PolicyContext>();
        if (policiesDirectory.exists() && rulesDirectory.exists()) {
            for (File policyFile : Objects.requireNonNull(policiesDirectory.listFiles())) {
                Policy policy = this.loadPolicy(policyFile);
                if (policy == null) continue;
                List<String> policyRulesFiles = policy.getRules().stream().map(Rule::getId).collect(Collectors.toList());
                policy.setRules(this.loadRules(rulesDirectory.toString(), policyRulesFiles));
                PolicyMetadata policyMetadata = new PolicyMetadata(policyFile.getPath(), this.getRepoHashOrLocalRepositoryString(repositoryPath));
                policiesContexts.add(new PolicyContext(policyMetadata, policy));
            }
        } else {
            if (!policiesDirectory.exists()) {
                LOGGER.error("Policies directory {} doesn't exists!", (Object)policiesDirectory);
            }
            if (!rulesDirectory.exists()) {
                LOGGER.error("Rules directory {} doesn't exists!", (Object)rulesDirectory);
            }
        }
        return policiesContexts;
    }

    private ArrayList<Rule> getRulesFromRulesMap(Map<String, Rule> repositoryRulesMap, List<String> rulesIds) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rulesIds.forEach(rule -> {
            if (repositoryRulesMap.containsKey(rule)) {
                rules.add((Rule)repositoryRulesMap.get(rule));
            } else {
                LOGGER.error("Rule not found {}", rule);
            }
        });
        return rules;
    }

    private Policy loadPolicy(File file) {
        try {
            Policy policy = (Policy)YAML_MAPPER.readValue(file, Policy.class);
            LOGGER.info("Successfully loaded policy: {}", (Object)policy.getPolicyId());
            return policy;
        }
        catch (IOException yamlIOException) {
            LOGGER.error(yamlIOException.getMessage());
            return null;
        }
    }

    private String getRepoHashOrLocalRepositoryString(String repository) {
        String repoHash = new File(repository + "/.git").exists() ? this.getRepoHash(new File(repository)) : "Local repository";
        return repoHash;
    }

    private String getRepoHash(File directory) {
        return this.executeShellCommand(Arrays.asList("git", "rev-parse", "HEAD"), directory.toString()).replace(System.lineSeparator(), "");
    }

    private void getGitRepository(String repository) {
        Path targetPath = this.getTargetProjectDirectoryPath(repository);
        if (Files.exists(targetPath, new LinkOption[0])) {
            this.executeShellCommand(Arrays.asList("git", "pull"), targetPath.toString());
        } else {
            this.executeShellCommand(Arrays.asList("git", "clone", repository, targetPath.toString()), null);
        }
    }

    private void copyLocalRepository(String repository) {
        try {
            File sourceDirectory = new File(repository);
            File destinationDirectory = this.getTargetProjectDirectoryPath(repository).toFile();
            FileUtils.deleteDirectory((File)destinationDirectory);
            FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory);
            LOGGER.info("Successfully copied {} to {}", (Object)sourceDirectory, (Object)destinationDirectory);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }

    private String executeShellCommand(List<String> command, String directory) {
        LOGGER.info("Running {}", (Object)String.join((CharSequence)" ", command));
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            if (directory != null) {
                processBuilder.directory(new File(directory));
            }
            Process process = processBuilder.start();
            String stdout = IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            String stderr = IOUtils.toString((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset());
            LOGGER.info("Standard output: {}", (Object)stdout);
            if (!stderr.isEmpty()) {
                LOGGER.info("Error output: {}", (Object)stderr);
            }
            return stdout;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    private String getProjectNameFromRepository(String repository) {
        return repository.replaceAll(".*/", "").replace(".git", "");
    }

    protected Path getTargetProjectDirectoryPath(String repository) {
        if (this.isGitRepository(repository)) {
            String[] tokens = repository.replace("git@", "").replace("https://", "").replace(":", "/").split("/");
            return Path.of(String.format("%s/%s/%s/%s", this.policyConfig.getRoot().replace("~", System.getProperty("user.home")), tokens[0], tokens[1], this.getProjectNameFromRepository(repository)), new String[0]);
        }
        return Path.of(String.format("%s/%s", this.policyConfig.getRoot().replace("~", System.getProperty("user.home")), this.getProjectNameFromRepository(repository)), new String[0]);
    }

    private boolean isGitRepository(String repository) {
        return repository.startsWith("git@") || repository.startsWith("https://");
    }
}

