/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.core;

import io.openraven.magpie.api.IntermediatePlugin;
import io.openraven.magpie.api.MagpiePlugin;
import io.openraven.magpie.api.OriginPlugin;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.api.TerminalPlugin;
import io.openraven.magpie.core.config.MagpieConfig;
import io.openraven.magpie.core.fifos.FifoManager;
import io.openraven.magpie.core.layers.Layer;
import io.openraven.magpie.core.layers.LayerManager;
import io.openraven.magpie.core.layers.LayerType;
import io.openraven.magpie.core.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Orchestrator {
    private static final List<Class<? extends MagpiePlugin>> DISCOVERY_PLUGIN_CLASSES = List.of(OriginPlugin.class, IntermediatePlugin.class, TerminalPlugin.class);
    private static final long LAYER_GRACE_PERIOD = 3000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Orchestrator.class);
    private final MagpieConfig config;
    private final Session session;

    public Orchestrator(MagpieConfig config, Session session) {
        this.config = config;
        this.session = session;
    }

    public void scan() {
        FifoManager fifoManager = new FifoManager(this.config);
        PluginManager pluginManager = new PluginManager(this.config);
        pluginManager.loadPlugins(DISCOVERY_PLUGIN_CLASSES);
        LayerManager layerManager = new LayerManager(this.session, this.config, fifoManager, pluginManager);
        Map<String, Layer> layers = layerManager.getLayers();
        ExecutorService executors = Executors.newFixedThreadPool(layers.size(), r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
        Set originLayers = layers.values().stream().filter(l -> l.getType() == LayerType.ORIGIN).collect(Collectors.toSet());
        Set otherLayers = layers.values().stream().filter(l -> !originLayers.contains(l)).collect(Collectors.toSet());
        ArrayList<LayerCallable> callables = new ArrayList<LayerCallable>();
        List originFutures = originLayers.stream().map(layer -> {
            LayerCallable c = new LayerCallable((Layer)layer, false);
            callables.add(c);
            LOGGER.trace("Submitting callable {}", (Object)c.layer.getName());
            return executors.submit(c);
        }).collect(Collectors.toList());
        List<Future> otherFutures = otherLayers.stream().map(layer -> {
            LayerCallable c = new LayerCallable((Layer)layer, true);
            callables.add(c);
            LOGGER.trace("Submitting callable {}", (Object)c.layer.getName());
            return executors.submit(c);
        }).collect(Collectors.toList());
        List<Future> futures = originFutures.isEmpty() ? otherFutures : originFutures;
        futures.forEach(f -> {
            try {
                f.get();
                LOGGER.trace("Got {}", f.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.error("Layer execution error", (Throwable)ex);
                System.exit(1);
            }
        });
        try {
            LOGGER.debug("Entering grace period");
            Thread.sleep(3000L);
            LOGGER.debug("Exited grade period");
        }
        catch (InterruptedException ex) {
            LOGGER.error("Grace period interrupted", (Throwable)ex);
        }
        LOGGER.debug("Shutting down layers");
        callables.forEach(LayerCallable::shutdown);
    }

    private class LayerCallable
    implements Callable<LayerType> {
        private final Layer layer;
        private volatile boolean repeat;

        public LayerCallable(Layer layer, Boolean repeat) {
            this.layer = layer;
            this.repeat = repeat;
        }

        @Override
        public LayerType call() throws Exception {
            do {
                try {
                    this.layer.exec();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Layer exec wait interrupted for {}", (Object)this.layer.getName(), (Object)ex);
                }
                catch (Exception ex) {
                    LOGGER.warn("Layer exception", (Throwable)ex);
                }
            } while (this.repeat);
            return this.layer.getType();
        }

        public void shutdown() {
            this.layer.shutdown();
            this.repeat = false;
        }
    }
}

