/*
 * Copyright 2021 Open Raven Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.openraven.magpie.core.dmap.model;

public class EC2Target {
  private final String resourceId;
  private final String ipAddress;

  public EC2Target(String resourceId, String ipAddress) {
    this.resourceId = resourceId;
    this.ipAddress = ipAddress;
  }

  public String getResourceId() {
    return resourceId;
  }

  public String getIpAddress() {
    return ipAddress;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    EC2Target ec2Target = (EC2Target) o;

    if (!resourceId.equals(ec2Target.resourceId)) return false;
    return ipAddress.equals(ec2Target.ipAddress);
  }

  @Override
  public int hashCode() {
    int result = resourceId.hashCode();
    result = 31 * result + ipAddress.hashCode();
    return result;
  }

  @Override
  public String toString() {
    return "EC2Target{" +
      "resourceId='" + resourceId + '\'' +
      ", ipAddress='" + ipAddress + '\'' +
      '}';
  }
}
