/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClientBuilder;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.GatewayInfo;

public class StorageGatewayDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "storageGateway";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return StorageGatewayClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::StorageGateway::Gateway";
        try (StorageGatewayClient client = (StorageGatewayClient)((StorageGatewayClientBuilder)clientCreator.apply(StorageGatewayClient.builder())).build();){
            client.listGatewaysPaginator().gateways().stream().forEach(gateway -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, gateway.gatewayARN()).withResourceName(gateway.gatewayName()).withResourceId(gateway.gatewayId()).withResourceType("AWS::StorageGateway::Gateway").withConfiguration(mapper.valueToTree((Object)gateway.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverGatewayInfo(client, (GatewayInfo)gateway, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":gateway"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::StorageGateway::Gateway", null, region, (SdkException)ex);
        }
    }

    private void discoverGatewayInfo(StorageGatewayClient client, GatewayInfo resource, MagpieAwsResource data) {
        String keyname = "gatewayInfo";
        AWSUtils.getAwsResponse(() -> client.describeGatewayInformation((DescribeGatewayInformationRequest)DescribeGatewayInformationRequest.builder().gatewayARN(resource.gatewayARN()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("gatewayInfo", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("gatewayInfo", noresp)));
    }
}

