/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.GuardDutyClientBuilder;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;

public class GuardDutyDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "guardduty";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return GuardDutyClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::GuardDuty::Detector";
        try (GuardDutyClient client = (GuardDutyClient)((GuardDutyClientBuilder)clientCreator.apply(GuardDutyClient.builder())).build();){
            client.listDetectorsPaginator().forEach(detector -> detector.detectorIds().forEach(id -> {
                GetDetectorResponse resp = client.getDetector((GetDetectorRequest)GetDetectorRequest.builder().detectorId(id).build());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, "arn:aws:guardduty:::detector/" + id).withResourceName(id).withResourceId(id).withResourceType("AWS::GuardDuty::Detector").withConfiguration(mapper.valueToTree((Object)resp.toBuilder())).withCreatedIso(Instant.parse(resp.createdAt())).withAccountId(account).withAwsRegion(region.toString()).build();
                AWSUtils.update(data.tags, (JsonNode)mapper.convertValue((Object)resp.tags(), JsonNode.class));
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":backupVault"), data.toJsonNode()));
            }));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::GuardDuty::Detector", null, region, (SdkException)ex);
        }
    }
}

