/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.plugins.aws.discovery.AWSDiscoveryPlugin;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionFilter;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AWSUtils {
    private static final JsonNode NULL_NODE = AWSDiscoveryPlugin.MAPPER.nullNode();
    private static final Logger LOGGER = LoggerFactory.getLogger(AWSUtils.class);

    public static <R> void getAwsResponse(Supplier<R> fn, Consumer<R> resp, Consumer<JsonNode> noresp) throws SdkClientException, SdkServiceException {
        try {
            R ret = fn.get();
            resp.accept(ret);
        }
        catch (SdkServiceException ex) {
            if (ex.statusCode() >= 400 && ex.statusCode() < 500) {
                noresp.accept(NULL_NODE);
            }
            throw ex;
        }
    }

    public static JsonNode update(@Nullable JsonNode payload, ToCopyableBuilder ... responsesToAdd) {
        for (ToCopyableBuilder responseToAdd : responsesToAdd) {
            if (responseToAdd == null) continue;
            JsonNode jsonNode = (JsonNode)AWSDiscoveryPlugin.MAPPER.convertValue((Object)responseToAdd.toBuilder(), JsonNode.class);
            payload = AWSUtils.update(payload, jsonNode);
        }
        return payload;
    }

    public static JsonNode update(@Nullable JsonNode payload, Map<String, Object> mappedResponsesToAdd) {
        for (Map.Entry<String, Object> responseToAdd : mappedResponsesToAdd.entrySet()) {
            ObjectNode nodeToAdd = AWSDiscoveryPlugin.MAPPER.createObjectNode();
            if (responseToAdd.getValue() instanceof ToCopyableBuilder) {
                nodeToAdd.set(responseToAdd.getKey(), (JsonNode)AWSDiscoveryPlugin.MAPPER.convertValue((Object)((ToCopyableBuilder)responseToAdd.getValue()).toBuilder(), JsonNode.class));
            } else {
                nodeToAdd.set(responseToAdd.getKey(), (JsonNode)AWSDiscoveryPlugin.MAPPER.convertValue(responseToAdd.getValue(), JsonNode.class));
            }
            payload = AWSUtils.update(payload, new JsonNode[]{nodeToAdd});
        }
        return payload;
    }

    public static JsonNode update(@Nullable JsonNode payload, JsonNode ... nodesToAdd) {
        for (JsonNode nodeToAdd : nodesToAdd) {
            if (nodeToAdd == null) continue;
            try {
                if (payload != null) {
                    payload = (JsonNode)AWSDiscoveryPlugin.MAPPER.readerForUpdating((Object)payload).readValue(nodeToAdd);
                    continue;
                }
                payload = nodeToAdd;
            }
            catch (IOException e) {
                LOGGER.warn("Unable to add extra data {}", (Object)nodeToAdd, (Object)e);
            }
        }
        return payload;
    }

    public static JsonNode update(ToCopyableBuilder ... responsesToAdd) {
        return AWSUtils.update(null, responsesToAdd);
    }

    public static JsonNode add(List<? extends ToCopyableBuilder> responsesToAdd) {
        List tags = responsesToAdd.stream().map(val -> (JsonNode)AWSDiscoveryPlugin.MAPPER.convertValue((Object)val.toBuilder(), JsonNode.class)).collect(Collectors.toList());
        ArrayNode payload = AWSDiscoveryPlugin.MAPPER.createArrayNode();
        payload.addAll(tags);
        return payload;
    }

    public static Pair<Long, GetMetricStatisticsResponse> getCloudwatchMetricMinimum(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getCloudwatchMetricStatistics(regionID, namespace, metric, Statistic.MINIMUM, dimensions, clientCreator);
        return Pair.with((Object)getMetricStatisticsResult.datapoints().stream().map(Datapoint::minimum).map(Double::longValue).max(Long::compareTo).orElse(null), (Object)getMetricStatisticsResult);
    }

    public static Pair<Long, GetMetricStatisticsResponse> getCloudwatchMetricMaximum(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getCloudwatchMetricStatistics(regionID, namespace, metric, Statistic.MAXIMUM, dimensions, clientCreator);
        return Pair.with((Object)getMetricStatisticsResult.datapoints().stream().map(Datapoint::maximum).map(Double::longValue).max(Long::compareTo).orElse(null), (Object)getMetricStatisticsResult);
    }

    public static List<Datapoint> getCloudwatchMetricStaleDataSum(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getStaleDataCloudwatchMetrics(regionID, namespace, metric, Statistic.SUM, dimensions, clientCreator);
        return getMetricStatisticsResult.datapoints();
    }

    public static List<Datapoint> getCloudwatchMetricStaleDataAvg(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getStaleDataCloudwatchMetrics(regionID, namespace, metric, Statistic.AVERAGE, dimensions, clientCreator);
        return getMetricStatisticsResult.datapoints();
    }

    public static Pair<Long, GetMetricStatisticsResponse> getCloudwatchMetricAverage(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getCloudwatchMetricStatistics(regionID, namespace, metric, Statistic.AVERAGE, dimensions, clientCreator);
        return Pair.with((Object)getMetricStatisticsResult.datapoints().stream().map(Datapoint::average).map(Double::longValue).max(Long::compareTo).orElse(null), (Object)getMetricStatisticsResult);
    }

    public static Pair<Double, GetMetricStatisticsResponse> getCloudwatchDoubleMetricMinimum(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getCloudwatchMetricStatistics(regionID, namespace, metric, Statistic.MINIMUM, dimensions, clientCreator);
        return Pair.with((Object)getMetricStatisticsResult.datapoints().stream().map(Datapoint::minimum).max(Double::compare).orElse(null), (Object)getMetricStatisticsResult);
    }

    public static Pair<Double, GetMetricStatisticsResponse> getCloudwatchDoubleMetricMaximum(String regionID, String namespace, String metric, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        GetMetricStatisticsResponse getMetricStatisticsResult = AWSUtils.getCloudwatchMetricStatistics(regionID, namespace, metric, Statistic.MAXIMUM, dimensions, clientCreator);
        return Pair.with((Object)getMetricStatisticsResult.datapoints().stream().map(Datapoint::maximum).max(Double::compare).orElse(null), (Object)getMetricStatisticsResult);
    }

    public static GetMetricStatisticsResponse getCloudwatchMetricStatistics(String regionID, String namespace, String metric, Statistic statistic, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        try (CloudWatchClient client = (CloudWatchClient)((CloudWatchClientBuilder)((CloudWatchClientBuilder)clientCreator.apply(CloudWatchClient.builder())).region(Region.of((String)regionID))).build();){
            Instant startTS = Instant.now().minus(2L, ChronoUnit.DAYS).truncatedTo(ChronoUnit.MINUTES);
            Instant endTS = Instant.now().minus(1L, ChronoUnit.HOURS).truncatedTo(ChronoUnit.MINUTES);
            GetMetricStatisticsRequest request = (GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().startTime(startTS).endTime(endTS).namespace(namespace).period(Integer.valueOf(3600)).metricName(metric).statistics(new Statistic[]{statistic}).dimensions(dimensions).build();
            GetMetricStatisticsResponse getMetricStatisticsResponse = client.getMetricStatistics(request);
            return getMetricStatisticsResponse;
        }
    }

    public static GetMetricStatisticsResponse getStaleDataCloudwatchMetrics(String regionID, String namespace, String metric, Statistic statistic, List<Dimension> dimensions, MagpieAWSClientCreator clientCreator) {
        try (CloudWatchClient client = (CloudWatchClient)((CloudWatchClientBuilder)((CloudWatchClientBuilder)clientCreator.apply(CloudWatchClient.builder())).region(Region.of((String)regionID))).build();){
            Instant startTS = Instant.now().minus(30L, ChronoUnit.DAYS).truncatedTo(ChronoUnit.MINUTES);
            Instant endTS = Instant.now().minus(1L, ChronoUnit.HOURS).truncatedTo(ChronoUnit.MINUTES);
            GetMetricStatisticsRequest request = (GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().startTime(startTS).endTime(endTS).namespace(namespace).period(Integer.valueOf(86400)).metricName(metric).statistics(new Statistic[]{statistic}).dimensions(dimensions).build();
            GetMetricStatisticsResponse getMetricStatisticsResponse = client.getMetricStatistics(request);
            return getMetricStatisticsResponse;
        }
    }

    public static List<String> getS3AvailableSizeMetrics(String regionID, String bucketName, MagpieAWSClientCreator clientCreator) {
        try (CloudWatchClient client = (CloudWatchClient)((CloudWatchClientBuilder)((CloudWatchClientBuilder)clientCreator.apply(CloudWatchClient.builder())).region(Region.of((String)regionID))).build();){
            ArrayList<String> availableMetrics = new ArrayList<String>();
            List<DimensionFilter> dimensions = Collections.singletonList((DimensionFilter)DimensionFilter.builder().name("BucketName").value(bucketName).build());
            ListMetricsRequest request = (ListMetricsRequest)ListMetricsRequest.builder().namespace("AWS/S3").metricName("BucketSizeBytes").dimensions(dimensions).build();
            ListMetricsResponse response = client.listMetrics(request);
            response.metrics().forEach(metric -> metric.dimensions().stream().filter(dimension -> "StorageType".equals(dimension.name())).map(Dimension::value).forEach(availableMetrics::add));
            ArrayList<String> arrayList = availableMetrics;
            return arrayList;
        }
    }

    public static JsonNode parsePolicyDocument(ObjectMapper mapper, String policyDocument) {
        try {
            return mapper.readTree(URLDecoder.decode(policyDocument, StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse policy document: " + policyDocument, e);
        }
    }
}

