/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.Tag;

public class ENIDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "eni";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (Ec2Client client = (Ec2Client)((Ec2ClientBuilder)clientCreator.apply(Ec2Client.builder())).build();){
            this.discoverNetworkInterfaces(mapper, session, client, region, emitter, account);
        }
    }

    private void discoverNetworkInterfaces(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::NetworkInterface";
        try {
            client.describeNetworkInterfacesPaginator((DescribeNetworkInterfacesRequest)DescribeNetworkInterfacesRequest.builder().build()).networkInterfaces().stream().forEach(networkInterface -> {
                String arn = String.format("arn:aws:ec2:%s:%s:network-interface/%s", region, account, networkInterface.networkInterfaceId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(networkInterface.networkInterfaceId()).withResourceId(networkInterface.networkInterfaceId()).withResourceType("AWS::EC2::NetworkInterface").withConfiguration(mapper.valueToTree((Object)networkInterface.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(networkInterface.tagSet(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:NetworkInterface"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::NetworkInterface", null, region, (SdkException)ex);
        }
    }

    private JsonNode getConvertedTags(List<Tag> tags, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(tags.stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Ec2Client.serviceMetadata().regions();
    }
}

