/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.Conversions;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClientBuilder;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus;
import software.amazon.awssdk.services.elasticsearch.model.Tag;

public class ESDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "es";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return ElasticsearchClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Elasticsearch::Domain";
        try (ElasticsearchClient client = (ElasticsearchClient)((ElasticsearchClientBuilder)clientCreator.apply(ElasticsearchClient.builder())).build();){
            client.listDomainNames().domainNames().stream().map(domainInfo -> client.describeElasticsearchDomain((DescribeElasticsearchDomainRequest)DescribeElasticsearchDomainRequest.builder().domainName(domainInfo.domainName()).build()).domainStatus()).forEach(domain -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, domain.arn()).withResourceName(domain.domainName()).withResourceId(domain.domainId()).withResourceType("AWS::Elasticsearch::Domain").withConfiguration(mapper.valueToTree((Object)domain.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverTags(client, (ElasticsearchDomainStatus)domain, data, mapper);
                this.discoverSize((ElasticsearchDomainStatus)domain, data, region, account, logger, clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":domain"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Elasticsearch::Domain", null, region, (SdkException)ex);
        }
    }

    private void discoverTags(ElasticsearchClient client, ElasticsearchDomainStatus resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTags(builder -> builder.arn(resource.arn())), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tagList().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }

    private void discoverSize(ElasticsearchDomainStatus resource, MagpieAwsResource data, Region region, String account, Logger logger, MagpieAWSClientCreator clientCreator) {
        try {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("DomainName").value(resource.domainName()).build());
            dimensions.add((Dimension)Dimension.builder().name("ClientId").value(account).build());
            Pair<Double, GetMetricStatisticsResponse> clusterUsedSpace = AWSUtils.getCloudwatchDoubleMetricMaximum(region.toString(), "AWS/ES", "ClusterUsedSpace", dimensions, clientCreator);
            if (clusterUsedSpace.getSize() > 0) {
                int numNodes = resource.elasticsearchClusterConfig().instanceCount();
                int volSizeAsGB = resource.ebsOptions().volumeSize();
                AWSUtils.update(data.supplementaryConfiguration, Map.of("clusterUsedSpace", clusterUsedSpace.getValue0()));
                data.maxSizeInBytes = Conversions.GibToBytes((long)numNodes * (long)volSizeAsGB);
                data.sizeInBytes = Conversions.MibToBytes(((Double)clusterUsedSpace.getValue0()).longValue());
            }
        }
        catch (Exception ex) {
            logger.debug("Failure on ES size discovery. Region - {}; ResourceArn - {}", new Object[]{region, resource.arn(), ex});
        }
    }
}

