/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.RedshiftClientBuilder;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "redshift";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return RedshiftClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Redshift::Cluster";
        try (RedshiftClient client = (RedshiftClient)((RedshiftClientBuilder)clientCreator.apply(RedshiftClient.builder())).build();){
            client.describeClustersPaginator().clusters().stream().forEach(cluster -> {
                String arn = String.format("arn:aws:redshift:%s:%s:cluster:%s", region, account, cluster.clusterIdentifier());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(cluster.dbName()).withResourceId(cluster.clusterIdentifier()).withResourceType("AWS::Redshift::Cluster").withConfiguration(mapper.valueToTree((Object)cluster.toBuilder())).withCreatedIso(cluster.clusterCreateTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverStorage(client, data);
                this.discoverSize((Cluster)cluster, data, region, logger, clientCreator);
                this.getCloudWatchMetrics((Cluster)cluster, data, logger, clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":cluster"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Redshift::Cluster", null, region, (SdkException)ex);
        }
    }

    private void discoverStorage(RedshiftClient client, MagpieAwsResource data) {
        AWSUtils.getAwsResponse(() -> ((RedshiftClient)client).describeStorage(), resp -> AWSUtils.update(data.supplementaryConfiguration, new ToCopyableBuilder[]{resp}), noresp -> AWSUtils.update(data.supplementaryConfiguration, noresp));
    }

    private void discoverSize(Cluster resource, MagpieAwsResource data, Region region, Logger logger, MagpieAWSClientCreator clientCreator) {
        try {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("ClusterIdentifier").value(resource.clusterIdentifier()).build());
            Pair<Double, GetMetricStatisticsResponse> percentageDiskSpaceUsed = AWSUtils.getCloudwatchDoubleMetricMaximum(region.toString(), "AWS/Redshift", "PercentageDiskSpaceUsed", dimensions, clientCreator);
            AWSUtils.update(data.supplementaryConfiguration, Map.of("PercentageDiskSpaceUsed", percentageDiskSpaceUsed.getValue0()));
            JsonNode storageCapacityNode = data.supplementaryConfiguration.at("/totalProvisionedStorageInMegaBytes");
            JsonNode usedPctNode = data.supplementaryConfiguration.at("/PercentageDiskSpaceUsed");
            if (!storageCapacityNode.isMissingNode() && !usedPctNode.isMissingNode()) {
                long capacityAsBytes = storageCapacityNode.asLong() * 1049000L;
                Double dataUsed = usedPctNode.asDouble() / 100.0 * (double)capacityAsBytes;
                data.sizeInBytes = dataUsed.longValue();
                data.maxSizeInBytes = capacityAsBytes;
            }
        }
        catch (Exception ex) {
            logger.warn("Failure on Redshift disk space size discovery, Region - {}; ClusterIdentifier - {}", new Object[]{region, resource.clusterIdentifier(), ex});
        }
    }

    private void getCloudWatchMetrics(Cluster cluster, MagpieAwsResource data, Logger logger, MagpieAWSClientCreator clientCreator) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        HashMap<String, Map<String, Double>> requestMetrics = new HashMap<String, Map<String, Double>>();
        dimensions.add((Dimension)Dimension.builder().name("ClusterIdentifier").value(cluster.clusterIdentifier()).build());
        List<Datapoint> writeIOPS = AWSUtils.getCloudwatchMetricStaleDataAvg(data.awsRegion, "AWS/Redshift", "WriteIOPS", dimensions, clientCreator);
        requestMetrics.put("WriteIOPS", this.formatDataMapAvg(writeIOPS));
        List<Datapoint> readIOPS = AWSUtils.getCloudwatchMetricStaleDataAvg(data.awsRegion, "AWS/Redshift", "ReadIOPS", dimensions, clientCreator);
        requestMetrics.put("ReadIOPS", this.formatDataMapAvg(readIOPS));
        AWSUtils.update(data.supplementaryConfiguration, Map.of("staleDataMetrics", requestMetrics));
    }

    private Map<String, Double> formatDataMapAvg(List<Datapoint> map) {
        HashMap<String, Double> datapointMetrics = new HashMap<String, Double>();
        for (Datapoint dp : map) {
            datapointMetrics.put(dp.timestamp().toString(), dp.average());
        }
        return datapointMetrics;
    }
}

