/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.qldb.QldbClientBuilder;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListLedgersRequest;
import software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest;

public class QLDBDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "qldb";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return QldbClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Qldb::Ledger";
        try (QldbClient client = (QldbClient)((QldbClientBuilder)clientCreator.apply(QldbClient.builder())).build();){
            client.listLedgersPaginator((ListLedgersRequest)ListLedgersRequest.builder().build()).stream().forEach(ledgerList -> ledgerList.ledgers().stream().map(ledgerSummary -> client.describeLedger((DescribeLedgerRequest)DescribeLedgerRequest.builder().name(ledgerSummary.name()).build())).forEach(ledger -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, ledger.arn()).withResourceName(ledger.name()).withResourceType("AWS::Qldb::Ledger").withConfiguration(mapper.valueToTree((Object)ledger.toBuilder())).withCreatedIso(ledger.creationDateTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverStreams(client, (DescribeLedgerResponse)ledger, data);
                this.discoverJournalS3Exports(client, (DescribeLedgerResponse)ledger, data);
                this.discoverTags(client, (DescribeLedgerResponse)ledger, data, mapper);
                this.discoverSize((DescribeLedgerResponse)ledger, data, region, clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":ledger"), data.toJsonNode()));
            }));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Qldb::Ledger", null, region, (SdkException)ex);
        }
    }

    private void discoverStreams(QldbClient client, DescribeLedgerResponse resource, MagpieAwsResource data) {
        String keyname = "streams";
        AWSUtils.getAwsResponse(() -> client.listJournalKinesisStreamsForLedgerPaginator((ListJournalKinesisStreamsForLedgerRequest)ListJournalKinesisStreamsForLedgerRequest.builder().ledgerName(resource.name()).build()).stream().map(ListJournalKinesisStreamsForLedgerResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("streams", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("streams", noresp)));
    }

    private void discoverJournalS3Exports(QldbClient client, DescribeLedgerResponse resource, MagpieAwsResource data) {
        String keyname = "journalS3Exports";
        AWSUtils.getAwsResponse(() -> client.listJournalS3ExportsForLedgerPaginator((ListJournalS3ExportsForLedgerRequest)ListJournalS3ExportsForLedgerRequest.builder().name(resource.name()).build()).stream().map(ListJournalS3ExportsForLedgerResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("journalS3Exports", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("journalS3Exports", noresp)));
    }

    private void discoverTags(QldbClient client, DescribeLedgerResponse resource, MagpieAwsResource data, ObjectMapper mapper) {
        String keyname = "tags";
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceArn(resource.arn()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("tags", mapper.convertValue((Object)resp.tags(), JsonNode.class))), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("tags", noresp)));
    }

    private void discoverSize(DescribeLedgerResponse resource, MagpieAwsResource data, Region region, MagpieAWSClientCreator clientCreator) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add((Dimension)Dimension.builder().name("LedgerName").value(resource.name()).build());
        Pair<Long, GetMetricStatisticsResponse> clusterSize = AWSUtils.getCloudwatchMetricMaximum(region.toString(), "AWS/QLDB", "JournalStorage", dimensions, clientCreator);
        if (clusterSize.getValue0() != null) {
            AWSUtils.update(data.supplementaryConfiguration, Map.of("JournalStorage", clusterSize.getValue0()));
            data.sizeInBytes = (Long)clusterSize.getValue0();
        }
    }
}

