/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.Vpc;

public class VPCDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "vpc";

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (Ec2Client client = (Ec2Client)((Ec2ClientBuilder)clientCreator.apply(Ec2Client.builder())).build();){
            this.discoverVpcs(mapper, session, client, region, emitter, account);
            this.discoverVpcPeeringConnections(mapper, session, client, region, emitter, account);
            this.discoverSubnets(mapper, session, client, region, emitter, account);
        }
    }

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Ec2Client.serviceMetadata().regions();
    }

    private void discoverVpcs(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::VPC";
        try {
            client.describeVpcsPaginator().vpcs().forEach(vpc -> {
                String arn = String.format("arn:aws:ec2:%s:%s:vpc/%s", region, account, vpc.vpcId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(vpc.vpcId()).withResourceId(vpc.vpcId()).withResourceType("AWS::EC2::VPC").withConfiguration(mapper.valueToTree((Object)vpc.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(vpc.tags(), mapper)).build();
                this.discoverFlowLogs(client, data, (Vpc)vpc);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService()), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::VPC", null, region, (SdkException)ex);
        }
    }

    private void discoverSubnets(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::Subnet";
        try {
            client.describeSubnetsPaginator().subnets().forEach(subnet -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, subnet.subnetArn()).withResourceName(subnet.subnetId()).withResourceId(subnet.subnetId()).withResourceType("AWS::EC2::Subnet").withConfiguration(mapper.valueToTree((Object)subnet.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(subnet.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService()), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Subnet", null, region, (SdkException)ex);
        }
    }

    private void discoverFlowLogs(Ec2Client client, MagpieAwsResource data, Vpc vpc) {
        String keyname = "flowLogs";
        Filter flowLogsFilter = (Filter)Filter.builder().name("resource-id").values(List.of(vpc.vpcId())).build();
        AWSUtils.getAwsResponse(() -> client.describeFlowLogs((DescribeFlowLogsRequest)DescribeFlowLogsRequest.builder().filter(new Filter[]{flowLogsFilter}).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("flowLogs", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("flowLogs", noresp)));
    }

    private void discoverVpcPeeringConnections(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::VPCPeeringConnection";
        try {
            client.describeVpcPeeringConnectionsPaginator().vpcPeeringConnections().forEach(vpcPC -> {
                String arn = String.format("arn:aws:ec2:%s:%s:vpc-peering-connection/%s", region, account, vpcPC.vpcPeeringConnectionId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(vpcPC.vpcPeeringConnectionId()).withResourceId(vpcPC.vpcPeeringConnectionId()).withResourceType("AWS::EC2::VPCPeeringConnection").withConfiguration(mapper.valueToTree((Object)vpcPC.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(vpcPC.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:vpcpc"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::VPCPeeringConnection", null, region, (SdkException)ex);
        }
    }

    private JsonNode getConvertedTags(List<Tag> tags, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(tags.stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }
}

