/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.data.aws.ec2.EC2SecurityGroup;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.protocol.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Tag;

public class EC2Discovery
implements AWSDiscovery {
    private static final String SERVICE = "ec2";
    private static final Pattern CIDR_REGEX = Pattern.compile("^((?:[0-9]{1,3}\\.){3}[0-9]{1,3})/([0-9]|[1-2][0-9]|3[0-2])?$");
    private static final String SINGLE_HOST_NETMASK = "255.255.255.255";
    private final Map<String, JsonNode> whoisCache = new HashMap<String, JsonNode>();

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (Ec2Client client = (Ec2Client)((Ec2ClientBuilder)clientCreator.apply(Ec2Client.builder())).build();){
            this.discoverEc2Instances(mapper, session, client, region, emitter, account, clientCreator, logger);
            this.discoverEIPs(mapper, session, client, region, emitter, account);
            this.discoverSecurityGroups(mapper, session, client, region, emitter, account, logger);
            this.discoverNetworkAcls(mapper, session, client, region, emitter, account);
            this.discoverTransitGateway(mapper, session, client, region, emitter, account);
        }
    }

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Ec2Client.serviceMetadata().regions();
    }

    private void discoverEc2Instances(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account, MagpieAWSClientCreator clientCreator, Logger logger) {
        String RESOURCE_TYPE = "AWS::EC2::Instance";
        try {
            client.describeInstancesPaginator().forEach(describeInstancesResponse -> describeInstancesResponse.reservations().forEach(reservation -> reservation.instances().forEach(instance -> {
                String arn = String.format("arn:aws:ec2:%s:%s:instance/%s", region, reservation.ownerId(), instance.instanceId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(instance.instanceId()).withResourceId(instance.instanceId()).withResourceType("AWS::EC2::Instance").withConfiguration(mapper.valueToTree((Object)instance.toBuilder())).withCreatedIso(instance.launchTime()).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(instance.tags(), mapper)).build();
                this.massageInstanceTypeAndPublicIp(data, (Instance)instance, mapper, region, "AWS::EC2::Instance");
                this.discoverBackupJobs(arn, region, data, clientCreator, logger);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService()), data.toJsonNode()));
            })));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Instance", null, region, (SdkException)ex);
        }
    }

    public void massageInstanceTypeAndPublicIp(MagpieAwsResource data, Instance instance, ObjectMapper mapper, Region region, String resourceType) {
        try {
            ObjectReader instanceForUpdate = mapper.readerForUpdating((Object)data.configuration);
            data.configuration = (JsonNode)instanceForUpdate.readValue((JsonNode)mapper.convertValue(Map.of("instanceType", instance.instanceTypeAsString()), JsonNode.class));
            if (!StringUtils.isEmpty((String)instance.publicIpAddress())) {
                data.configuration = (JsonNode)instanceForUpdate.readValue((JsonNode)mapper.convertValue(Map.of("publicIp", instance.publicIpAddress()), JsonNode.class));
            }
        }
        catch (IOException ex) {
            DiscoveryExceptions.onDiscoveryException(resourceType, null, region, ex);
        }
    }

    private void discoverEIPs(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::EIP";
        try {
            client.describeAddresses().addresses().forEach(eip -> {
                String arn = String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", region, account, eip.allocationId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(eip.publicIp()).withResourceId(eip.allocationId()).withResourceType("AWS::EC2::EIP").withConfiguration(mapper.valueToTree((Object)eip.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(eip.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:eip"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::EIP", null, region, (SdkException)ex);
        }
    }

    private void discoverSecurityGroups(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account, Logger logger) {
        String RESOURCE_TYPE = "AWS::EC2::SecurityGroup";
        try {
            client.describeSecurityGroupsPaginator().stream().flatMap(r -> r.securityGroups().stream()).forEach(securityGroup -> {
                String arn = String.format("arn:aws:ec2:%s:%s:security-group/%s", region, account, securityGroup.groupId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(securityGroup.groupName()).withResourceId(securityGroup.groupId()).withResourceType("AWS::EC2::SecurityGroup").withConfiguration(mapper.valueToTree((Object)securityGroup.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(securityGroup.tags(), mapper)).build();
                JsonNode egressNode = data.configuration.get("ipPermissionsEgress");
                if (egressNode instanceof ArrayNode) {
                    this.updateIpPermissionsEgressNode((ArrayNode)egressNode, mapper);
                }
                List cidrOwnersList = StreamSupport.stream(data.configuration.get("ipPermissions").spliterator(), false).flatMap(perm -> StreamSupport.stream(perm.get("ipRanges").spliterator(), false)).map(ipRange -> ipRange.get("cidrIp").textValue()).filter(cidrIp -> !"0.0.0.0/0".equals(cidrIp)).map(cidr -> this.ipOwnerLookup(arn, (String)cidr, logger, mapper)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                AWSUtils.update(data.supplementaryConfiguration, Map.of("ipPermissionsCidrOwners", cidrOwnersList));
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:securityGroup"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::SecurityGroup", null, region, (SdkException)ex);
        }
    }

    private void discoverNetworkAcls(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::NetworkAcl";
        try {
            client.describeNetworkAclsPaginator((DescribeNetworkAclsRequest)DescribeNetworkAclsRequest.builder().build()).networkAcls().stream().forEach(acl -> {
                String arn = String.format("arn:aws:ec2:%s:%s:network-acl/%s", region, account, acl.networkAclId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(acl.networkAclId()).withResourceId(acl.networkAclId()).withResourceType("AWS::EC2::NetworkAcl").withConfiguration(mapper.valueToTree((Object)acl.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(acl.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:NetworkAcl"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::NetworkAcl", null, region, (SdkException)ex);
        }
    }

    private void discoverTransitGateway(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::TransitGateway";
        try {
            client.describeTransitGateways().transitGateways().forEach(transitGateway -> {
                String arn = String.format("arn:aws:ec2:%s:%s:transit-gateway/%s", region, account, transitGateway.transitGatewayId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(transitGateway.transitGatewayId()).withResourceId(transitGateway.transitGatewayId()).withResourceType("AWS::EC2::TransitGateway").withConfiguration(mapper.valueToTree((Object)transitGateway.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(transitGateway.tags(), mapper)).build();
                this.discoverTransit(client, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:TransitGateway"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::TransitGateway", null, region, (SdkException)ex);
        }
    }

    private void discoverTransit(Ec2Client client, MagpieAwsResource data) {
        String keyname = "transit";
        AWSUtils.getAwsResponse(() -> client.describeTransitGateways((DescribeTransitGatewaysRequest)DescribeTransitGatewaysRequest.builder().build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("transit", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("transit", noresp)));
    }

    private JsonNode getConvertedTags(List<Tag> tags, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(tags.stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }

    private Optional<EC2SecurityGroup.OwnerCIDR> ipOwnerLookup(String resourceARN, String cidr, Logger logger, ObjectMapper mapper) {
        JsonNode whoisResponse = null;
        try {
            Matcher cidrValidate = CIDR_REGEX.matcher(cidr);
            if (!cidrValidate.find()) {
                logger.warn("CIDR {} was not a valid format", (Object)cidr);
                return Optional.empty();
            }
            SubnetUtils.SubnetInfo sgSubnet = new SubnetUtils(cidr).getInfo();
            whoisResponse = this.whoisCall(cidr, logger, mapper);
            if (whoisResponse != null) {
                String orgName = whoisResponse.at("/net/orgRef/@name").textValue();
                String customerName = whoisResponse.at("/net/customerRef/@name").textValue();
                String ownername = orgName != null ? orgName : customerName;
                boolean isBadCidr = SINGLE_HOST_NETMASK.equals(sgSubnet.getNetmask());
                JsonNode netblocks = whoisResponse.requiredAt("/net/netBlocks");
                JsonNode netblock = netblocks.requiredAt("/netBlock");
                if (!netblock.isArray()) {
                    if (isBadCidr || this.isSgInWhoisNetblock(sgSubnet, netblock)) {
                        String startAddress = netblock.requiredAt("/startAddress/$").textValue();
                        String cidrLength = netblock.requiredAt("/cidrLength/$").textValue();
                        return Optional.of(new EC2SecurityGroup.OwnerCIDR(cidr, ownername, startAddress + "/" + cidrLength, isBadCidr));
                    }
                } else {
                    for (JsonNode n : netblock) {
                        if (!isBadCidr && !this.isSgInWhoisNetblock(sgSubnet, n)) continue;
                        String startAddress = n.requiredAt("/startAddress/$").textValue();
                        String cidrLength = n.requiredAt("/cidrLength/$").textValue();
                        return Optional.of(new EC2SecurityGroup.OwnerCIDR(cidr, ownername, startAddress + "/" + cidrLength, isBadCidr));
                    }
                }
            }
            if (whoisResponse != null) {
                logger.info("NULL whois lookup - https://openraven.atlassian.net/browse/ENG-5286");
            }
            return Optional.empty();
        }
        catch (EC2SecurityGroup.WhoisLookupException e) {
            logger.error("Error while getting IP owner for {}", (Object)cidr, (Object)e);
            SentryEvent event = new SentryEvent((Throwable)e);
            Message message = new Message();
            message.setMessage("WHOIS owner lookup exception while running EC2 SecurityGroup discovery");
            event.setMessage(message);
            event.setLevel(SentryLevel.ERROR);
            event.setExtra("Resource", (Object)resourceARN);
            event.setExtra("CIDR", (Object)cidr);
            event.setExtra("Reason", (Object)e);
            Sentry.captureEvent((SentryEvent)event);
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            logger.warn("Malformed whois output: <<{}>>", whoisResponse, (Object)e);
            SentryEvent event = new SentryEvent((Throwable)e);
            Message message = new Message();
            message.setMessage("Malformed whois output");
            event.setMessage(message);
            event.setLevel(SentryLevel.ERROR);
            event.setExtra("Resource", (Object)resourceARN);
            event.setExtra("CIDR", (Object)cidr);
            return Optional.empty();
        }
    }

    @Nullable
    private JsonNode whoisCall(String cidr, Logger logger, ObjectMapper mapper) throws EC2SecurityGroup.WhoisLookupException {
        if (this.whoisCache.containsKey(cidr)) {
            return this.whoisCache.get(cidr);
        }
        Matcher ipFromCidr = CIDR_REGEX.matcher(cidr);
        if (!ipFromCidr.find()) {
            logger.warn("CIDR {} was not a valid format", (Object)cidr);
            throw new EC2SecurityGroup.WhoisLookupException(String.format("CIDR %s was not a valid format", cidr));
        }
        String ip = ipFromCidr.group(1);
        String whoisReq = "http://whois.arin.net/rest/ip/" + ip;
        HttpResponse response = ((GetRequest)Unirest.get((String)whoisReq).header("Accept", ContentType.APPLICATION_JSON.toString())).asString();
        if (response.getStatus() == 200) {
            try {
                JsonNode whoisResp = mapper.readTree((String)response.getBody());
                if (!whoisResp.at("/net/resources/limitExceeded/$").asBoolean()) {
                    this.whoisCache.put(cidr, whoisResp);
                    return whoisResp;
                }
                SentryEvent event = new SentryEvent();
                Message message = new Message();
                message.setMessage("whois look rate limited");
                event.setMessage(message);
                event.setLevel(SentryLevel.WARNING);
                event.setExtra("CIDR", (Object)cidr);
                Sentry.captureEvent((SentryEvent)event);
                return null;
            }
            catch (JsonProcessingException e) {
                throw (EC2SecurityGroup.WhoisLookupException)new EC2SecurityGroup.WhoisLookupException("Error processing whois response to " + whoisReq).initCause((Throwable)e);
            }
        }
        logger.warn("Bogus whois repsonse: {}", (Object)response);
        return null;
    }

    private boolean isSgInWhoisNetblock(SubnetUtils.SubnetInfo sgSubnet, JsonNode netblock) {
        long sgLowAddressInt = this.ipToLong(sgSubnet.getLowAddress());
        long sgHighAddressInt = this.ipToLong(sgSubnet.getHighAddress());
        long whoisLowAddressInt = this.ipToLong(netblock.requiredAt("/startAddress/$").textValue());
        long whoisHighAddressInt = this.ipToLong(netblock.requiredAt("/endAddress/$").textValue());
        return sgLowAddressInt >= whoisLowAddressInt && sgHighAddressInt <= whoisHighAddressInt;
    }

    private long ipToLong(String ipAddress) {
        long result = 0L;
        String[] ipAddressInArray = ipAddress.split("\\.");
        for (int i = 3; i >= 0; --i) {
            long ip = Long.parseLong(ipAddressInArray[3 - i]);
            result |= ip << i * 8;
        }
        return result;
    }

    private void updateIpPermissionsEgressNode(ArrayNode ipPermissionsEgressNode, ObjectMapper mapper) {
        for (int i = 0; i < ipPermissionsEgressNode.size(); ++i) {
            ObjectNode objNode = (ObjectNode)ipPermissionsEgressNode.get(i);
            ArrayNode ipRangesNode = (ArrayNode)objNode.get("ipRanges");
            for (int j = 0; j < ipRangesNode.size(); ++j) {
                ObjectNode child = (ObjectNode)ipRangesNode.get(j);
                ipRangesNode.set(j, mapper.valueToTree((Object)child.get("cidrIp")));
            }
        }
    }
}

