/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.BackupUtils;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.model.BackupJob;

public interface AWSDiscovery {
    public String service();

    default public void discoverWrapper(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        logger.debug("Starting {} discovery in {}", (Object)this.service(), (Object)region);
        this.discover(mapper, session, region, emitter, logger, account, clientCreator);
        logger.debug("Completed {} discovery in {}", (Object)this.service(), (Object)region);
    }

    public void discover(ObjectMapper var1, Session var2, Region var3, Emitter var4, Logger var5, String var6, MagpieAWSClientCreator var7);

    default public void discoverBackupJobs(String arn, Region region, MagpieAwsResource data, MagpieAWSClientCreator clientCreator, Logger logger) {
        List<BackupJob.Builder> backups = BackupUtils.listBackupJobs(arn, region, clientCreator, logger);
        AWSUtils.update(data.supplementaryConfiguration, Map.of("awsBackupJobs", backups));
    }

    default public String fullService() {
        return "magpie.aws.discovery:" + this.service();
    }

    public List<Region> getSupportedRegions();
}

