/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.BucketLocationConstraint;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.PolicyStatus;
import software.amazon.awssdk.services.s3.model.Tag;

public class S3Discovery
implements AWSDiscovery {
    private static final String SERVICE = "s3";
    private static final String DEFAULT_AWS_US_EAST_1_URI = "https://s3.us-east-1.amazonaws.com";
    private static final Cache<String, Map<Region, List<Bucket>>> bucketCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(20L)).build();

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return S3Client.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::S3::Bucket";
        try (S3Client client = this.configureS3Client(clientCreator, region);){
            Optional<List<Bucket>> bucketOpt = this.getBuckets(session.getId() + account, client, region, logger);
            if (bucketOpt.isEmpty()) {
                logger.debug("No buckets found for {}", (Object)region);
                return;
            }
            bucketOpt.get().forEach(bucket -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, "arn:aws:s3:::" + bucket.name()).withResourceName(bucket.name()).withResourceId(bucket.name()).withResourceType("AWS::S3::Bucket").withConfiguration(mapper.valueToTree((Object)bucket.toBuilder())).withCreatedIso(bucket.creationDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverEncryption(client, (Bucket)bucket, data);
                this.discoverHosting(client, (Bucket)bucket, data);
                this.discoverACLS(client, (Bucket)bucket, data);
                this.discoverPublicAccess(client, (Bucket)bucket, data);
                this.discoverLogging(client, (Bucket)bucket, data);
                this.discoverMetrics(client, (Bucket)bucket, data);
                this.discoverNotifications(client, (Bucket)bucket, data);
                this.discoverBucketPolicy(client, (Bucket)bucket, data, mapper);
                this.discoverObjectLockConfiguration(client, (Bucket)bucket, data);
                this.discoverReplication(client, (Bucket)bucket, data);
                this.discoverPublic(client, (Bucket)bucket, data, logger);
                this.discoverVersioning(client, (Bucket)bucket, data);
                this.discoverBucketTags(client, (Bucket)bucket, data, mapper);
                this.discoverSize((Bucket)bucket, data, clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":bucket"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::S3::Bucket", null, region, (SdkException)ex);
        }
    }

    private S3Client configureS3Client(MagpieAWSClientCreator clientCreator, Region region) {
        S3ClientBuilder builder = (S3ClientBuilder)clientCreator.apply(S3Client.builder());
        String magpieAwsEndpoint = System.getProperty("MAGPIE_AWS_ENDPOINT");
        if (magpieAwsEndpoint != null) {
            builder.endpointOverride(URI.create(magpieAwsEndpoint));
        } else if (Region.US_EAST_1.equals(region) || Region.AWS_GLOBAL.equals(region)) {
            builder.endpointOverride(URI.create(DEFAULT_AWS_US_EAST_1_URI));
        }
        return (S3Client)((S3ClientBuilder)builder.region(region)).build();
    }

    private Optional<List<Bucket>> getBuckets(String cacheKey, S3Client client, Region bucketRegion, Logger logger) {
        try {
            Map buckets = (Map)bucketCache.get((Object)cacheKey, () -> {
                logger.debug("No cache found for {}, creating one now.", (Object)cacheKey);
                HashMap map = new HashMap();
                client.listBuckets().buckets().forEach(bucket -> {
                    GetBucketLocationResponse resp = client.getBucketLocation((GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(bucket.name()).build());
                    BucketLocationConstraint location = resp.locationConstraint();
                    Region region = Region.US_EAST_1.toString().equals(resp.locationConstraintAsString()) || resp.locationConstraintAsString().isEmpty() ? Region.US_EAST_1 : Region.of((String)location.toString());
                    logger.debug("Associating {} to region {}", (Object)bucket.name(), (Object)region);
                    List list = map.getOrDefault(region, new LinkedList());
                    list.add(bucket);
                    map.put(region, list);
                });
                return map;
            });
            return Optional.ofNullable((List)buckets.get(bucketRegion));
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("S3 Discovery failed", ex);
        }
    }

    private void discoverPublic(S3Client client, Bucket resource, MagpieAwsResource data, Logger logger) {
        boolean isPublicByACL = false;
        boolean isPublicByPolicy = false;
        try {
            GetBucketAclResponse bucketAcl = client.getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(resource.name()).build());
            isPublicByACL = bucketAcl.grants().stream().anyMatch(grant -> "http://acs.amazonaws.com/groups/global/AllUsers".equalsIgnoreCase(grant.grantee().uri()) || "http://acs.amazonaws.com/groups/global/AuthenticatedUsers".equalsIgnoreCase(grant.grantee().uri()));
        }
        catch (SdkServiceException ex) {
            if (ex.statusCode() != 403 && ex.statusCode() != 404) {
                throw ex;
            }
            logger.warn("Failure on S3 public access discovery, BucketName: {}, Reason: {}", (Object)resource.name(), (Object)ex.getMessage());
        }
        try {
            GetBucketPolicyStatusResponse bucketPolicyStatus = client.getBucketPolicyStatus((GetBucketPolicyStatusRequest)GetBucketPolicyStatusRequest.builder().bucket(resource.name()).build());
            isPublicByPolicy = Optional.of(bucketPolicyStatus.policyStatus()).map(PolicyStatus::isPublic).orElse(false);
        }
        catch (SdkServiceException ex) {
            if (ex.statusCode() != 403 && ex.statusCode() != 404) {
                throw ex;
            }
            logger.warn("Failure on S3 public access discovery, BucketName: {}, Reason: {}", (Object)resource.name(), (Object)ex.getMessage());
        }
        AWSUtils.update(data.supplementaryConfiguration, Map.of("isPublic", isPublicByACL || isPublicByPolicy, "isPublicByACL", isPublicByACL, "isPublicByPolicy", isPublicByPolicy));
    }

    private void discoverACLS(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "BucketACLConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(resource.name()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketACLConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketACLConfiguration", noresp)));
    }

    private void discoverEncryption(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "ServerSideEncryptionConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketEncryption((GetBucketEncryptionRequest)GetBucketEncryptionRequest.builder().bucket(resource.name()).build()).serverSideEncryptionConfiguration(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("ServerSideEncryptionConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("ServerSideEncryptionConfiguration", noresp)));
    }

    private void discoverVersioning(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "Versioning";
        AWSUtils.getAwsResponse(() -> client.getBucketVersioning((GetBucketVersioningRequest)GetBucketVersioningRequest.builder().bucket(resource.name()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("Versioning", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("Versioning", noresp)));
    }

    private void discoverHosting(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "BucketWebsiteConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketWebsite((GetBucketWebsiteRequest)GetBucketWebsiteRequest.builder().bucket(resource.name()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketWebsiteConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketWebsiteConfiguration", noresp)));
    }

    private void discoverObjectLockConfiguration(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "BucketObjectLockConfiguration";
        AWSUtils.getAwsResponse(() -> client.getObjectLockConfiguration((GetObjectLockConfigurationRequest)GetObjectLockConfigurationRequest.builder().bucket(resource.name()).build()).objectLockConfiguration(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketObjectLockConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketObjectLockConfiguration", noresp)));
    }

    private void discoverLogging(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "BucketLoggingConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketLogging((GetBucketLoggingRequest)GetBucketLoggingRequest.builder().bucket(resource.name()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketLoggingConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketLoggingConfiguration", noresp)));
    }

    private void discoverMetrics(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "MetricsConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketMetricsConfiguration((GetBucketMetricsConfigurationRequest)GetBucketMetricsConfigurationRequest.builder().bucket(resource.name()).build()).metricsConfiguration(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("MetricsConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("MetricsConfiguration", noresp)));
    }

    private void discoverNotifications(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "NotificationConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketNotificationConfiguration((GetBucketNotificationConfigurationRequest)GetBucketNotificationConfigurationRequest.builder().bucket(resource.name()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("NotificationConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("NotificationConfiguration", noresp)));
    }

    private void discoverPublicAccess(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "PublicAccessBlockConfiguration";
        AWSUtils.getAwsResponse(() -> client.getPublicAccessBlock((GetPublicAccessBlockRequest)GetPublicAccessBlockRequest.builder().bucket(resource.name()).build()).publicAccessBlockConfiguration(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("PublicAccessBlockConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("PublicAccessBlockConfiguration", noresp)));
    }

    private void discoverBucketPolicy(S3Client client, Bucket resource, MagpieAwsResource data, ObjectMapper mapper) {
        String keyname = "BucketPolicyStatus";
        AWSUtils.getAwsResponse(() -> client.getBucketPolicyStatus((GetBucketPolicyStatusRequest)GetBucketPolicyStatusRequest.builder().bucket(resource.name()).build()).policyStatus(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketPolicyStatus", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketPolicyStatus", noresp)));
        String keyname2 = "BucketPolicy";
        AWSUtils.getAwsResponse(() -> client.getBucketPolicy((GetBucketPolicyRequest)GetBucketPolicyRequest.builder().bucket(resource.name()).build()).policy(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketPolicy", AWSUtils.parsePolicyDocument(mapper, resp))), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("BucketPolicy", noresp)));
    }

    private void discoverReplication(S3Client client, Bucket resource, MagpieAwsResource data) {
        String keyname = "ReplicationConfiguration";
        AWSUtils.getAwsResponse(() -> client.getBucketReplication((GetBucketReplicationRequest)GetBucketReplicationRequest.builder().bucket(resource.name()).build()).replicationConfiguration(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("ReplicationConfiguration", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("ReplicationConfiguration", noresp)));
    }

    private void discoverBucketTags(S3Client client, Bucket resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.getBucketTagging((GetBucketTaggingRequest)GetBucketTaggingRequest.builder().bucket(resource.name()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tagSet().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }

    private void discoverSize(Bucket resource, MagpieAwsResource data, MagpieAWSClientCreator clientCreator) {
        List<String> storageTypeDimensions = AWSUtils.getS3AvailableSizeMetrics(data.awsRegion, data.resourceName, clientCreator);
        ArrayList<Map<String, Long>> storageTypeMap = new ArrayList<Map<String, Long>>();
        for (String storageType : storageTypeDimensions) {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("BucketName").value(resource.name()).build());
            dimensions.add((Dimension)Dimension.builder().name("StorageType").value(storageType).build());
            Pair<Long, GetMetricStatisticsResponse> bucketSizeBytes = AWSUtils.getCloudwatchMetricMaximum(data.awsRegion, "AWS/S3", "BucketSizeBytes", dimensions, clientCreator);
            Long bucketSizeMetric = (Long)bucketSizeBytes.getValue0();
            if (bucketSizeMetric == null) continue;
            storageTypeMap.add(Map.of(storageType, bucketSizeMetric));
        }
        data.supplementaryConfiguration = AWSUtils.update(data.supplementaryConfiguration, Map.of("storageTypeSizeInBytes", storageTypeMap));
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add((Dimension)Dimension.builder().name("BucketName").value(resource.name()).build());
        dimensions.add((Dimension)Dimension.builder().name("StorageType").value("StandardStorage").build());
        Pair<Long, GetMetricStatisticsResponse> bucketSizeBytes = AWSUtils.getCloudwatchMetricMaximum(data.awsRegion, "AWS/S3", "BucketSizeBytes", dimensions, clientCreator);
        ArrayList<Dimension> dimensions2 = new ArrayList<Dimension>();
        dimensions2.add((Dimension)Dimension.builder().name("BucketName").value(resource.name()).build());
        dimensions2.add((Dimension)Dimension.builder().name("StorageType").value("AllStorageTypes").build());
        Pair<Long, GetMetricStatisticsResponse> numberOfObjects = AWSUtils.getCloudwatchMetricMaximum(data.awsRegion, "AWS/S3", "NumberOfObjects", dimensions2, clientCreator);
        if (numberOfObjects.getValue0() != null && bucketSizeBytes.getValue0() != null) {
            AWSUtils.update(data.supplementaryConfiguration, Map.of("size", Map.of("BucketSizeBytes", (Long)bucketSizeBytes.getValue0(), "NumberOfObjects", (Long)numberOfObjects.getValue0())));
            data.sizeInBytes = (Long)bucketSizeBytes.getValue0();
        }
    }
}

