/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.ConfigClientBuilder;
import software.amazon.awssdk.services.config.model.ConfigurationRecorder;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;

public class ConfigDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "config";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return ConfigClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Config::ConfigurationRecorder";
        try (ConfigClient client = (ConfigClient)((ConfigClientBuilder)clientCreator.apply(ConfigClient.builder())).build();){
            client.describeConfigurationRecorders().configurationRecorders().forEach(configurationRecorder -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, configurationRecorder.roleARN()).withResourceName(configurationRecorder.name()).withResourceType("AWS::Config::ConfigurationRecorder").withConfiguration(mapper.valueToTree((Object)configurationRecorder.toBuilder())).withAwsRegion(region.toString()).withAccountId(account).build();
                this.discoverConfigurationRecorderStatus(client, (ConfigurationRecorder)configurationRecorder, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":configurationRecorder"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Config::ConfigurationRecorder", null, region, (SdkException)ex);
        }
    }

    private void discoverConfigurationRecorderStatus(ConfigClient client, ConfigurationRecorder resource, MagpieAwsResource data) {
        String keyname = "status";
        DescribeConfigurationRecorderStatusRequest request = (DescribeConfigurationRecorderStatusRequest)DescribeConfigurationRecorderStatusRequest.builder().configurationRecorderNames(new String[]{resource.name()}).build();
        AWSUtils.getAwsResponse(() -> client.describeConfigurationRecorderStatus(request).configurationRecordersStatus(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("status", resp.get(0))), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("status", noresp)));
    }
}

