/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;

public class ELBDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "elb";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return ElasticLoadBalancingClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::ElasticLoadBalancing::LoadBalancer";
        try (ElasticLoadBalancingClient client = (ElasticLoadBalancingClient)((ElasticLoadBalancingClientBuilder)clientCreator.apply(ElasticLoadBalancingClient.builder())).build();){
            client.describeLoadBalancers().loadBalancerDescriptions().forEach(loadBalancer -> {
                String name = loadBalancer.loadBalancerName();
                String arn = String.format("arn:aws:elasticloadbalancing:%s:%s:loadbalancer/%s", region, account, name);
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(loadBalancer.dnsName()).withResourceId(name).withResourceType("AWS::ElasticLoadBalancing::LoadBalancer").withConfiguration(mapper.valueToTree((Object)loadBalancer.toBuilder())).withCreatedIso(loadBalancer.createdTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverAttributes(client, (LoadBalancerDescription)loadBalancer, data, mapper);
                this.discoverTags(client, (LoadBalancerDescription)loadBalancer, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":loadBalancer"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::ElasticLoadBalancing::LoadBalancer", null, region, (SdkException)ex);
        }
    }

    private void discoverAttributes(ElasticLoadBalancingClient client, LoadBalancerDescription resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.describeLoadBalancerAttributes((DescribeLoadBalancerAttributesRequest)DescribeLoadBalancerAttributesRequest.builder().loadBalancerName(resource.loadBalancerName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attributes", resp.toBuilder())), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attributes", noresp)));
    }

    private void discoverTags(ElasticLoadBalancingClient client, LoadBalancerDescription resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.describeTags((DescribeTagsRequest)DescribeTagsRequest.builder().loadBalancerNames(new String[]{resource.loadBalancerName()}).build()).tagDescriptions(), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.stream().flatMap(tagDescription -> tagDescription.tags().stream()).collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }
}

