/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.amazonaws.arn.Arn;
import com.amazonaws.arn.ArnResource;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;

public class SNSDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "sns";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return SnsClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (SnsClient client = (SnsClient)((SnsClientBuilder)clientCreator.apply(SnsClient.builder())).build();){
            this.discoverTopics(client, mapper, session, region, emitter);
            this.discoverSubscriptions(client, mapper, session, region, emitter);
        }
    }

    private void discoverTopics(SnsClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter) {
        String RESOURCE_TYPE = "AWS::SNS::Topic";
        try {
            client.listTopics().topics().stream().map(topic -> client.getTopicAttributes((GetTopicAttributesRequest)GetTopicAttributesRequest.builder().topicArn(topic.topicArn()).build())).forEach(attributesResp -> {
                Map attributes = attributesResp.attributes();
                String arn = (String)attributes.get("TopicArn");
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, (String)attributes.get("TopicArn")).withResourceName((String)attributes.get("DisplayName")).withResourceType("AWS::SNS::Topic").withConfiguration(mapper.valueToTree((Object)attributesResp.toBuilder())).withAccountId((String)attributesResp.attributes().get("Owner")).withAwsRegion(Arn.fromString((String)arn).getRegion()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":topic"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::SNS::Topic", null, region, (SdkException)ex);
        }
    }

    private void discoverSubscriptions(SnsClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter) {
        String RESOURCE_TYPE = "AWS::SNS::Subscription";
        try {
            client.listSubscriptions().subscriptions().stream().map(subscription -> client.getSubscriptionAttributes((GetSubscriptionAttributesRequest)GetSubscriptionAttributesRequest.builder().subscriptionArn(subscription.subscriptionArn()).build())).forEach(attributesResp -> {
                Map attributes = attributesResp.attributes();
                Arn arn = Arn.fromString((String)((String)attributes.get("SubscriptionArn")));
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn.toString()).withResourceName(this.getName(arn)).withResourceType("AWS::SNS::Subscription").withConfiguration(mapper.valueToTree((Object)attributesResp.toBuilder())).withAccountId(arn.getAccountId()).withAwsRegion(arn.getRegion()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":subscription"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::SNS::Subscription", null, region, (SdkException)ex);
        }
    }

    private String getName(Arn arn) {
        ArnResource res = arn.getResource();
        return res.getResourceType() + ":" + res.getResource();
    }
}

