/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.EcsClientBuilder;
import software.amazon.awssdk.services.ecs.model.Cluster;
import software.amazon.awssdk.services.ecs.model.DescribeClustersRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTasksRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTasksResponse;
import software.amazon.awssdk.services.ecs.model.ListAttributesRequest;
import software.amazon.awssdk.services.ecs.model.ListServicesRequest;
import software.amazon.awssdk.services.ecs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecs.model.ListTasksRequest;
import software.amazon.awssdk.services.ecs.model.Tag;

public class ECSDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "ecs";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return EcsClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::ECS::Cluster";
        try (EcsClient client = (EcsClient)((EcsClientBuilder)clientCreator.apply(EcsClient.builder())).build();){
            this.listDescribedClusters(client).forEach(cluster -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, cluster.clusterArn()).withResourceName(cluster.clusterName()).withResourceType("AWS::ECS::Cluster").withConfiguration(mapper.valueToTree((Object)cluster.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverAttributes(client, (Cluster)cluster, data);
                this.discoverServices(client, (Cluster)cluster, data);
                this.discoverTasks(client, (Cluster)cluster, data);
                this.discoverTags(client, (Cluster)cluster, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":cluster"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::ECS::Cluster", null, region, (SdkException)ex);
        }
    }

    private List<Cluster> listDescribedClusters(EcsClient client) {
        List clusterArns = client.listClustersPaginator().clusterArns().stream().collect(Collectors.toList());
        return client.describeClusters((DescribeClustersRequest)DescribeClustersRequest.builder().clusters(clusterArns).build()).clusters();
    }

    private void discoverTags(EcsClient client, Cluster resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceArn(resource.clusterArn()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }

    private void discoverAttributes(EcsClient client, Cluster resource, MagpieAwsResource data) {
        String keyname = "attributes";
        AWSUtils.getAwsResponse(() -> client.listAttributes((ListAttributesRequest)ListAttributesRequest.builder().targetType("container-instance").cluster(resource.clusterArn()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attributes", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attributes", noresp)));
    }

    private void discoverServices(EcsClient client, Cluster resource, MagpieAwsResource data) {
        String keyname = "services";
        AWSUtils.getAwsResponse(() -> this.listDescribedServices(client, resource), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("services", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("services", noresp)));
    }

    private DescribeServicesResponse listDescribedServices(EcsClient client, Cluster resource) {
        List serviceArns = client.listServicesPaginator((ListServicesRequest)ListServicesRequest.builder().cluster(resource.clusterArn()).build()).serviceArns().stream().collect(Collectors.toList());
        return client.describeServices((DescribeServicesRequest)DescribeServicesRequest.builder().cluster(resource.clusterArn()).services(serviceArns).build());
    }

    private void discoverTasks(EcsClient client, Cluster resource, MagpieAwsResource data) {
        String keyname = "tasks";
        AWSUtils.getAwsResponse(() -> this.listDescribedTasks(client, resource), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("tasks", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("tasks", noresp)));
    }

    private DescribeTasksResponse listDescribedTasks(EcsClient client, Cluster resource) {
        List instanceArns = client.listTasksPaginator((ListTasksRequest)ListTasksRequest.builder().cluster(resource.clusterArn()).build()).taskArns().stream().collect(Collectors.toList());
        return client.describeTasks((DescribeTasksRequest)DescribeTasksRequest.builder().cluster(resource.clusterArn()).tasks(instanceArns).build());
    }
}

