/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import com.amazonaws.SdkClientException;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.time.Instant;
import java.time.Period;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.BackupClientBuilder;
import software.amazon.awssdk.services.backup.model.BackupJob;
import software.amazon.awssdk.services.backup.model.BackupJobState;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable;

public class BackupUtils {
    private static final Period HISTORY = Period.ofDays(45);
    public static final String UNSUPPORTED_RESOURCE_TYPE_STRING_INDICATOR = "Unsupported resource type";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<BackupJob.Builder> listBackupJobs(String arn, Region region, MagpieAWSClientCreator clientCreator, Logger logger) {
        AtomicInteger retries = new AtomicInteger(5);
        LinkedList<BackupJob.Builder> jobs = new LinkedList<BackupJob.Builder>();
        while (retries.get() > 0) {
            try {
                BackupClient client = (BackupClient)((BackupClientBuilder)((BackupClientBuilder)clientCreator.apply(BackupClient.builder())).region(region)).build();
                try {
                    ListBackupJobsRequest.Builder builder = ListBackupJobsRequest.builder().byResourceArn(arn).byCreatedAfter(Instant.now().minus(HISTORY)).maxResults(Integer.valueOf(1000)).byState(BackupJobState.COMPLETED);
                    ListBackupJobsIterable result = client.listBackupJobsPaginator((ListBackupJobsRequest)builder.build());
                    result.forEach(response -> jobs.addAll(response.backupJobs().stream().map(BackupJob::toBuilder).collect(Collectors.toList())));
                    if (client == null) return jobs;
                }
                catch (Throwable throwable) {
                    try {
                        if (client == null) throw throwable;
                        try {
                            client.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (SdkClientException ex) {
                        if (retries.get() == 0) {
                            throw ex;
                        }
                        logger.warn("Couldn't list backup jobs for {}, retrying {} more times", (Object)arn, (Object)retries);
                        retries.decrementAndGet();
                        continue;
                    }
                    catch (Exception ex) {
                        if (String.valueOf(ex.getMessage()).contains(UNSUPPORTED_RESOURCE_TYPE_STRING_INDICATOR)) return jobs;
                        DiscoveryExceptions.onDiscoveryException("AWS::Backup::BackupPlan", arn, region, ex);
                        continue;
                    }
                }
                client.close();
                return jobs;
            }
            finally {
                retries.decrementAndGet();
            }
        }
        return jobs;
    }
}

