/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.BackupClientBuilder;
import software.amazon.awssdk.services.backup.model.BackupPlansListMember;
import software.amazon.awssdk.services.backup.model.BackupVaultListMember;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BackupDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "backup";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return BackupClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (BackupClient client = (BackupClient)((BackupClientBuilder)clientCreator.apply(BackupClient.builder())).build();){
            this.discoverVaults(mapper, session, region, emitter, account, client);
            this.discoverPlans(mapper, session, region, emitter, logger, account, client);
        }
    }

    public void discoverPlans(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, BackupClient client) {
        String RESOURCE_TYPE = "AWS::Backup::BackupPlan";
        client.listBackupPlans().backupPlansList().forEach(backupPlan -> {
            MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, backupPlan.backupPlanArn()).withResourceName(backupPlan.backupPlanName()).withResourceId(backupPlan.backupPlanId()).withResourceType("AWS::Backup::BackupPlan").withConfiguration(mapper.valueToTree((Object)backupPlan.toBuilder())).withCreatedIso(backupPlan.creationDate()).withAccountId(account).withAwsRegion(region.toString()).build();
            this.getPlanDetails(client, data);
            this.discoverTags(client, (BackupPlansListMember)backupPlan, data, mapper);
            ArrayList backupSelections = new ArrayList();
            client.listBackupSelectionsPaginator((ListBackupSelectionsRequest)ListBackupSelectionsRequest.builder().backupPlanId(backupPlan.backupPlanId()).build()).forEach(listBackupSelectionsResp -> listBackupSelectionsResp.backupSelectionsList().forEach(backupSelection -> {
                GetBackupSelectionResponse backupSelectionResp = client.getBackupSelection((GetBackupSelectionRequest)GetBackupSelectionRequest.builder().backupPlanId(backupSelection.backupPlanId()).selectionId(backupSelection.selectionId()).build());
                backupSelections.add(backupSelectionResp.toBuilder());
            }));
            AWSUtils.update(data.supplementaryConfiguration, Map.of("backupSelections", backupSelections));
            emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":backupVault"), data.toJsonNode()));
        });
    }

    public void discoverVaults(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, BackupClient client) {
        String RESOURCE_TYPE = "AWS::Backup::BackupVault";
        try {
            client.listBackupVaults().backupVaultList().stream().forEach(backupVault -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, backupVault.backupVaultArn()).withResourceName(backupVault.backupVaultName()).withResourceId(backupVault.backupVaultName()).withResourceType("AWS::Backup::BackupVault").withCreatedIso(backupVault.creationDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                AWSUtils.update(data.configuration, new ToCopyableBuilder[]{backupVault});
                this.discoverVaultTags(client, (BackupVaultListMember)backupVault, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":backupVault"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Backup::BackupVault", null, region, (SdkException)ex);
        }
    }

    private void discoverVaultTags(BackupClient client, BackupVaultListMember resource, MagpieAwsResource data) {
        String keyname = "Tags";
        AWSUtils.getAwsResponse(() -> client.listTags((ListTagsRequest)ListTagsRequest.builder().resourceArn(resource.backupVaultArn()).build()), resp -> {
            data.supplementaryConfiguration = AWSUtils.update(data.supplementaryConfiguration, Map.of("Tags", resp));
        }, noresp -> {
            data.supplementaryConfiguration = AWSUtils.update(data.supplementaryConfiguration, Map.of("Tags", noresp));
        });
    }

    private void getPlanDetails(BackupClient client, MagpieAwsResource data) {
        AWSUtils.getAwsResponse(() -> client.getBackupPlan((GetBackupPlanRequest)GetBackupPlanRequest.builder().backupPlanId(data.resourceId).build()), resp -> AWSUtils.update(data.configuration, new ToCopyableBuilder[]{resp}), noresp -> AWSUtils.update(data.supplementaryConfiguration, noresp));
    }

    private void discoverTags(BackupClient client, BackupPlansListMember resource, MagpieAwsResource data, ObjectMapper mapper) {
        String keyname = "Tags";
        AWSUtils.getAwsResponse(() -> client.listTagsPaginator((ListTagsRequest)ListTagsRequest.builder().resourceArn(resource.backupPlanArn()).build()).stream().flatMap(r -> r.tags().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), resp -> {
            data.tags = (JsonNode)mapper.convertValue(resp, JsonNode.class);
        }, noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("Tags", noresp)));
    }
}

