/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.Tag;

public class EC2StorageDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "ec2storage";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (Ec2Client client = (Ec2Client)((Ec2ClientBuilder)clientCreator.apply(Ec2Client.builder())).build();){
            this.discoverSnapshots(mapper, session, client, region, emitter, account, logger);
            this.discoverVolumes(mapper, session, client, region, emitter, account);
        }
    }

    private void discoverSnapshots(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account, Logger logger) {
        String RESOURCE_TYPE = "AWS::EC2::Snapshot";
        try {
            client.describeSnapshotsPaginator((DescribeSnapshotsRequest)DescribeSnapshotsRequest.builder().ownerIds(new String[]{account}).build()).snapshots().stream().forEach(snapshot -> {
                String arn = String.format("arn:aws:ec2:%s:%s:snapshot/%s", region, account, snapshot.snapshotId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(snapshot.snapshotId()).withResourceId(snapshot.snapshotId()).withResourceType("AWS::EC2::Snapshot").withConfiguration(mapper.valueToTree((Object)snapshot.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(snapshot.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:Volume"), data.toJsonNode()));
            });
        }
        catch (Ec2Exception ex) {
            logger.info("Error discovering snapshots", (Throwable)ex);
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Snapshot", null, region, (SdkException)ex);
        }
    }

    private void discoverVolumes(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::Volume";
        try {
            client.describeVolumesPaginator().stream().flatMap(r -> r.volumes().stream()).forEach(volume -> {
                String arn = String.format("arn:aws:ec2:%s:%s:volume/%s", region, account, volume.volumeId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(volume.volumeId()).withResourceId(volume.volumeId()).withResourceType("AWS::EC2::Volume").withConfiguration(mapper.valueToTree((Object)volume.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(volume.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:Volume"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Volume", null, region, (SdkException)ex);
        }
    }

    private JsonNode getConvertedTags(List<Tag> tags, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(tags.stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Ec2Client.serviceMetadata().regions();
    }
}

