/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import io.openraven.magpie.plugins.aws.discovery.exception.AwsDiscoveryException;
import java.io.IOException;
import java.util.Properties;

public class VersionProvider {
    private static final String RESOURCE = "version.properties";
    private final String awsSdkVersion;
    private final String projectVersion;

    public VersionProvider() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream(RESOURCE));
        }
        catch (IOException e) {
            throw new AwsDiscoveryException("Unable to parse properties from version.properties resource", e);
        }
        this.awsSdkVersion = properties.getProperty("aws.sdk.version");
        this.projectVersion = properties.getProperty("project.version");
    }

    public String getAwsSdkVersion() {
        return this.awsSdkVersion;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }
}

