/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.OriginPlugin;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSDiscoveryConfig;
import io.openraven.magpie.plugins.aws.discovery.ClientCreators;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.AthenaDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.BackupDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.BatchDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.CassandraDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.CloudFrontDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.CloudSearchDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.CloudTrailDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.CloudWatchDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.CloudWatchLogsDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ConfigDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.DynamoDbDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.EBDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.EC2Discovery;
import io.openraven.magpie.plugins.aws.discovery.services.EC2StorageDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ECSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.EFSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.EKSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ELBDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ELBV2Discovery;
import io.openraven.magpie.plugins.aws.discovery.services.EMRDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ENIDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ESDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.ElastiCacheDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.FSXDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.GlacierDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.GuardDutyDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.IAMDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.KMSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.LakeFormationDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.LambdaDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.LightsailDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.LocationDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.OrganizationDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.QLDBDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.RDSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.RedshiftDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.RegionDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.Route53Discovery;
import io.openraven.magpie.plugins.aws.discovery.services.S3Discovery;
import io.openraven.magpie.plugins.aws.discovery.services.SNSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.SSMDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.SecretsManagerDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.SecurityHubDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.StorageGatewayDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.VPCDiscovery;
import io.sentry.Sentry;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public class AWSDiscoveryPlugin
implements OriginPlugin<AWSDiscoveryConfig> {
    public static final String ID = "magpie.aws.discovery";
    protected static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).findAndRegisterModules();
    private static final List<AWSDiscovery> DISCOVERY_LIST = List.of(new AthenaDiscovery(), new BatchDiscovery(), new CassandraDiscovery(), new BackupDiscovery(), new CloudFrontDiscovery(), new CloudSearchDiscovery(), new CloudTrailDiscovery(), new CloudWatchDiscovery(), new CloudWatchLogsDiscovery(), new ConfigDiscovery(), new DynamoDbDiscovery(), new EBDiscovery(), new EC2Discovery(), new EC2StorageDiscovery(), new ECSDiscovery(), new EFSDiscovery(), new EKSDiscovery(), new ElastiCacheDiscovery(), new ELBDiscovery(), new ELBV2Discovery(), new EMRDiscovery(), new ENIDiscovery(), new ESDiscovery(), new FSXDiscovery(), new GlacierDiscovery(), new GuardDutyDiscovery(), new IAMDiscovery(), new LakeFormationDiscovery(), new LambdaDiscovery(), new LightsailDiscovery(), new LocationDiscovery(), new QLDBDiscovery(), new S3Discovery(), new SecretsManagerDiscovery(), new SecurityHubDiscovery(), new SNSDiscovery(), new SSMDiscovery(), new StorageGatewayDiscovery(), new RDSDiscovery(), new RedshiftDiscovery(), new Route53Discovery(), new KMSDiscovery(), new VPCDiscovery(), new RegionDiscovery(), new OrganizationDiscovery());
    private Logger logger;
    private AWSDiscoveryConfig config;

    public void discover(Session session, Emitter emitter) {
        List<AWSDiscovery> enabledPlugins = DISCOVERY_LIST.stream().filter(p -> this.isEnabled(p.service())).collect(Collectors.toList());
        if (this.config.getAssumedRoles() == null || this.config.getAssumedRoles().isEmpty()) {
            try (StsClient client = StsClient.create();){
                String account = client.getCallerIdentity().account();
                enabledPlugins.forEach(plugin -> {
                    List<Region> regions = this.getRegionsForDiscovery((AWSDiscovery)plugin);
                    regions.forEach(region -> {
                        try {
                            MagpieAWSClientCreator clientCreator = ClientCreators.localClientCreator(region);
                            plugin.discoverWrapper(MAPPER, session, (Region)region, emitter, this.logger, account, clientCreator);
                        }
                        catch (Exception ex) {
                            this.logger.error("Discovery error  in {} - {}", (Object)region.id(), (Object)ex.getMessage());
                            this.logger.debug("Details", (Throwable)ex);
                        }
                    });
                });
            }
        } else {
            this.config.getAssumedRoles().forEach(role -> enabledPlugins.forEach(plugin -> {
                List<Region> regions = this.getRegionsForDiscovery((AWSDiscovery)plugin);
                regions.forEach(region -> {
                    MagpieAWSClientCreator clientCreator = ClientCreators.assumeRoleCreator(region, role, Optional.ofNullable(this.config.getExternalId()));
                    try (StsClient client = (StsClient)((StsClientBuilder)clientCreator.apply(StsClient.builder())).build();){
                        String account = client.getCallerIdentity().account();
                        this.logger.info("Discovering cross-account {}:{} using role {}", new Object[]{plugin.service(), region, role});
                        plugin.discoverWrapper(MAPPER, session, (Region)region, emitter, this.logger, account, clientCreator);
                    }
                    catch (Exception ex) {
                        this.logger.error("Discovery error  in {} - {}", (Object)region.id(), (Object)ex.getMessage());
                        this.logger.debug("Details", (Throwable)ex);
                    }
                });
            }));
        }
    }

    protected List<Region> getRegionsForDiscovery(AWSDiscovery plugin) {
        List<Region> regions = plugin.getSupportedRegions().stream().filter(region -> this.isDiscoveryEnabledIn(region.toString())).filter(region -> this.isAllowedRegion(region.toString())).collect(Collectors.toList());
        if (regions.isEmpty()) {
            this.logger.warn("{} is enabled but no supported regions are configured.", (Object)plugin.fullService());
        }
        return regions;
    }

    private boolean isEnabled(String svc) {
        boolean enabled = this.config.getServices().isEmpty() || this.config.getServices().stream().anyMatch(configuredService -> configuredService.equalsIgnoreCase(svc));
        this.logger.debug("{} {} per config", (Object)(enabled ? "Enabling" : "Disabling"), (Object)svc);
        return enabled;
    }

    private boolean isDiscoveryEnabledIn(String region) {
        boolean enabled = this.config.getRegions().isEmpty() || this.config.getRegions().contains(region);
        this.logger.debug("{} {} per config", (Object)(enabled ? "Enabling" : "Disabling"), (Object)region);
        return enabled;
    }

    private boolean isAllowedRegion(String region) {
        boolean regionAllowed = this.config.getIgnoredRegions().stream().noneMatch(pattern -> Pattern.matches(pattern, region));
        this.logger.debug("{} {} per ignore region config", (Object)(regionAllowed ? "Enabling" : "Disabling"), (Object)region);
        return regionAllowed;
    }

    public String id() {
        return ID;
    }

    public void init(AWSDiscoveryConfig config, Logger logger) {
        this.logger = logger;
        this.config = config;
        try {
            Sentry.init();
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Could not initialize Sentry: {}", (Object)ex.getMessage());
        }
    }

    public Class<AWSDiscoveryConfig> configType() {
        return AWSDiscoveryConfig.class;
    }
}

