/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.SecurityHubClientBuilder;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;

public class SecurityHubDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "securityhub";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return SecurityHubClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::SecurityHub::StandardsSubscription";
        try (SecurityHubClient client = (SecurityHubClient)((SecurityHubClientBuilder)clientCreator.apply(SecurityHubClient.builder())).build();){
            client.getEnabledStandardsPaginator((GetEnabledStandardsRequest)GetEnabledStandardsRequest.builder().build()).forEach(resp -> resp.standardsSubscriptions().forEach(sub -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, sub.standardsSubscriptionArn()).withResourceName(sub.standardsSubscriptionArn()).withResourceId(sub.standardsSubscriptionArn()).withResourceType("AWS::SecurityHub::StandardsSubscription").withConfiguration(mapper.valueToTree((Object)sub.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":standardsSubscription"), data.toJsonNode()));
            }));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::SecurityHub::StandardsSubscription", null, region, (SdkException)ex);
        }
    }
}

