/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.Route53ClientBuilder;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class Route53Discovery
implements AWSDiscovery {
    private static final String SERVICE = "route53";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Route53Client.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Route53::HostedZone";
        try (Route53Client client = (Route53Client)((Route53ClientBuilder)clientCreator.apply(Route53Client.builder())).build();){
            client.listHostedZonesPaginator().hostedZones().stream().forEach(hostedZone -> {
                String arn = String.format("arn:aws:route53:::hostedZone/%s", hostedZone.id());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(hostedZone.name()).withResourceId(hostedZone.id()).withResourceType("AWS::Route53::HostedZone").withConfiguration(mapper.valueToTree((Object)hostedZone.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverRecordSets(client, (HostedZone)hostedZone, data);
                this.discoverTrafficPolicyInstances(client, (HostedZone)hostedZone, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":hostedZone"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Route53::HostedZone", null, region, (SdkException)ex);
        }
    }

    private void discoverRecordSets(Route53Client client, HostedZone resource, MagpieAwsResource data) {
        String keyname = "RecordSets";
        AWSUtils.getAwsResponse(() -> client.listResourceRecordSetsPaginator((ListResourceRecordSetsRequest)ListResourceRecordSetsRequest.builder().hostedZoneId(resource.id()).build()).resourceRecordSets().stream().map(ResourceRecordSet::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("RecordSets", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("RecordSets", noresp)));
    }

    private void discoverTrafficPolicyInstances(Route53Client client, HostedZone resource, MagpieAwsResource data) {
        String keyname = "TrafficPolicyInstances";
        AWSUtils.getAwsResponse(() -> client.listTrafficPolicyInstancesByHostedZone((ListTrafficPolicyInstancesByHostedZoneRequest)ListTrafficPolicyInstancesByHostedZoneRequest.builder().hostedZoneId(resource.id()).build()).trafficPolicyInstances(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("TrafficPolicyInstances", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("TrafficPolicyInstances", noresp)));
    }
}

