/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;

public class DiscoveryExceptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryExceptions.class);

    public static void onDiscoveryException(String resourceType, String resourceName, Region region, AwsServiceException exception) {
        DiscoveryExceptions.handleOrReportError(new EventBuilder().withMessage(resourceType + " AwsServiceException").withLevel(Event.Level.WARNING), resourceType, resourceName, region, (Exception)exception);
    }

    public static void onDiscoveryException(String resourceType, String resourceName, Region region, SdkServiceException exception) {
        DiscoveryExceptions.handleOrReportError(new EventBuilder().withMessage(resourceType + " SdkServiceException").withLevel(Event.Level.ERROR), resourceType, resourceName, region, (Exception)((Object)exception));
    }

    public static void onDiscoveryException(String resourceType, String resourceName, Region region, SdkException exception) {
        DiscoveryExceptions.handleOrReportError(new EventBuilder().withMessage(resourceType + " SdkException").withLevel(Event.Level.ERROR), resourceType, resourceName, region, (Exception)exception);
    }

    public static void onDiscoveryException(String resourceType, String resourceName, Region region, Exception exception) {
        DiscoveryExceptions.handleOrReportError(new EventBuilder().withMessage(resourceType + " Exception").withLevel(Event.Level.ERROR), resourceType, resourceName, region, exception);
    }

    private static void handleOrReportError(EventBuilder eventBuilder, String resourceType, String resourceName, Region region, Exception exception) {
        if (!DiscoveryExceptions.isManagedSdkException(resourceType, resourceName, exception)) {
            DiscoveryExceptions.logErrorAndReportToSentry(resourceType, resourceName, region, eventBuilder, exception);
        }
    }

    private static boolean isManagedSdkException(String resourceType, String resourceName, Exception exception) {
        if (exception instanceof SdkServiceException && ((SdkServiceException)((Object)exception)).isThrottlingException()) {
            LOGGER.warn("{} - Throttling exception on {}, with error {}", new Object[]{resourceType, resourceName, exception.getMessage()});
            return true;
        }
        if (exception instanceof SdkServiceException && ((SdkServiceException)((Object)exception)).isClockSkewException()) {
            LOGGER.warn("{} - Clock skew exception on {}, with error {}", new Object[]{resourceType, resourceName, exception.getMessage()});
            return true;
        }
        if (exception instanceof SdkServiceException && ((SdkServiceException)((Object)exception)).statusCode() == 404) {
            LOGGER.warn("404 when accessing resource {}", (Object)resourceName);
            return true;
        }
        if (exception.getMessage().contains("STS is not activated in this region")) {
            LOGGER.info("STS is not activated in this region for resource {}", (Object)resourceName, (Object)exception);
            return true;
        }
        if (exception.getMessage().contains("not authorized to perform") || exception.getMessage().contains("AccessDenied") || exception.getMessage().contains("Access Denied")) {
            LOGGER.info("Access denied on {}", (Object)resourceName);
            return true;
        }
        if (exception.getMessage().contains("The AWS Access Key Id needs a subscription for the service")) {
            LOGGER.info("The AWS Access Key Id needs a subscription for the service for resource {}", (Object)resourceName);
            return true;
        }
        return false;
    }

    private static void logErrorAndReportToSentry(String resourceType, String resourceName, Region region, EventBuilder eventBuilder, Exception exception) {
        LOGGER.error("{} - " + exception.getClass().getTypeName() + " on {} in {}, with error {}", new Object[]{resourceType, resourceName, region, exception.getMessage()});
        Sentry.capture((EventBuilder)eventBuilder.withExtra("Resource", (Object)String.valueOf(resourceType)).withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)exception)));
    }
}

