/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Snapshot;
import software.amazon.awssdk.services.ec2.model.Tag;

public class EC2Discovery
implements AWSDiscovery {
    private static final String SERVICE = "ec2";

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (Ec2Client client = (Ec2Client)((Ec2ClientBuilder)clientCreator.apply(Ec2Client.builder())).build();){
            this.discoverEc2Instances(mapper, session, client, region, emitter, account, clientCreator, logger);
            this.discoverEIPs(mapper, session, client, region, emitter, account);
            this.discoverSecurityGroups(mapper, session, client, region, emitter, account);
            this.discoverVolumes(mapper, session, client, region, emitter, account);
            this.discoverSnapshots(mapper, session, client, region, emitter, account, logger);
            this.discoverNetworkAcls(mapper, session, client, region, emitter, account);
        }
    }

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Ec2Client.serviceMetadata().regions();
    }

    private void discoverEc2Instances(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account, MagpieAWSClientCreator clientCreator, Logger logger) {
        String RESOURCE_TYPE = "AWS::EC2::Instance";
        try {
            client.describeInstancesPaginator().forEach(describeInstancesResponse -> describeInstancesResponse.reservations().forEach(reservation -> reservation.instances().forEach(instance -> {
                String arn = String.format("arn:aws:ec2:%s:%s:instance/%s", region, reservation.ownerId(), instance.instanceId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(instance.instanceId()).withResourceId(instance.instanceId()).withResourceType("AWS::EC2::Instance").withConfiguration(mapper.valueToTree((Object)instance.toBuilder())).withCreatedIso(instance.launchTime()).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(instance.tags(), mapper)).build();
                this.massageInstanceTypeAndPublicIp(data, (Instance)instance, mapper, region, "AWS::EC2::Instance");
                this.discoverBackupJobs(arn, region, data, clientCreator, logger);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService()), data.toJsonNode()));
            })));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Instance", null, region, (SdkException)ex);
        }
    }

    public void massageInstanceTypeAndPublicIp(MagpieAwsResource data, Instance instance, ObjectMapper mapper, Region region, String resourceType) {
        try {
            ObjectReader instanceForUpdate = mapper.readerForUpdating((Object)data.configuration);
            data.configuration = (JsonNode)instanceForUpdate.readValue((JsonNode)mapper.convertValue(Map.of("instanceType", instance.instanceTypeAsString()), JsonNode.class));
            if (!StringUtils.isEmpty((String)instance.publicIpAddress())) {
                data.configuration = (JsonNode)instanceForUpdate.readValue((JsonNode)mapper.convertValue(Map.of("publicIp", instance.publicIpAddress()), JsonNode.class));
            }
        }
        catch (IOException ex) {
            DiscoveryExceptions.onDiscoveryException(resourceType, null, region, ex);
        }
    }

    private void discoverEIPs(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::EIP";
        try {
            client.describeAddresses().addresses().forEach(eip -> {
                String arn = String.format("arn:aws:ec2:%s:%s:eip-allocation/%s", region, account, eip.allocationId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(eip.publicIp()).withResourceId(eip.allocationId()).withResourceType("AWS::EC2::EIP").withConfiguration(mapper.valueToTree((Object)eip.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(eip.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:eip"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::EIP", null, region, (SdkException)ex);
        }
    }

    private void discoverSecurityGroups(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::SecurityGroup";
        try {
            client.describeSecurityGroupsPaginator().stream().flatMap(r -> r.securityGroups().stream()).forEach(securityGroup -> {
                String arn = String.format("arn:aws:ec2:%s:%s:security-group/%s", region, account, securityGroup.groupId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(securityGroup.groupName()).withResourceId(securityGroup.groupId()).withResourceType("AWS::EC2::SecurityGroup").withConfiguration(mapper.valueToTree((Object)securityGroup.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(securityGroup.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:securityGroup"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::SecurityGroup", null, region, (SdkException)ex);
        }
    }

    private void discoverVolumes(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::Volume";
        try {
            client.describeVolumesPaginator().stream().flatMap(r -> r.volumes().stream()).forEach(volume -> {
                String arn = String.format("arn:aws:ec2:%s:%s:volume/%s", region, account, volume.volumeId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(volume.volumeId()).withResourceId(volume.volumeId()).withResourceType("AWS::EC2::Volume").withConfiguration(mapper.valueToTree((Object)volume.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(volume.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:Volume"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Volume", null, region, (SdkException)ex);
        }
    }

    private void discoverSnapshots(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account, Logger logger) {
        String RESOURCE_TYPE = "AWS::EC2::Snapshot";
        try {
            client.describeSnapshotsPaginator((DescribeSnapshotsRequest)DescribeSnapshotsRequest.builder().ownerIds(new String[]{account}).build()).snapshots().stream().forEach(snapshot -> {
                String arn = String.format("arn:aws:ec2:%s:%s:snapshot/%s", region, account, snapshot.snapshotId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(snapshot.snapshotId()).withResourceId(snapshot.snapshotId()).withResourceType("AWS::EC2::Snapshot").withConfiguration(mapper.valueToTree((Object)snapshot.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(snapshot.tags(), mapper)).build();
                this.discoverSnapshotVolumes(client, data, (Snapshot)snapshot);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:Volume"), data.toJsonNode()));
            });
        }
        catch (Ec2Exception ex) {
            logger.info("Error discovering snapshots", (Throwable)ex);
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::Snapshot", null, region, (SdkException)ex);
        }
    }

    private void discoverSnapshotVolumes(Ec2Client client, MagpieAwsResource data, Snapshot snapshot) {
        String keyname = "volumes";
        Filter snapshotFilter = (Filter)Filter.builder().name("snapshot-id").values(List.of(snapshot.snapshotId())).build();
        AWSUtils.getAwsResponse(() -> client.describeVolumesPaginator((DescribeVolumesRequest)DescribeVolumesRequest.builder().filters(List.of(snapshotFilter)).build()).stream().map(DescribeVolumesResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("volumes", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("volumes", noresp)));
    }

    private void discoverNetworkAcls(ObjectMapper mapper, Session session, Ec2Client client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::EC2::NetworkAcl";
        try {
            client.describeNetworkAclsPaginator((DescribeNetworkAclsRequest)DescribeNetworkAclsRequest.builder().build()).networkAcls().stream().forEach(acl -> {
                String arn = String.format("arn:aws:ec2:%s:%s:network-acl/%s", region, account, acl.networkAclId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(acl.networkAclId()).withResourceId(acl.networkAclId()).withResourceType("AWS::EC2::NetworkAcl").withConfiguration(mapper.valueToTree((Object)acl.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).withTags(this.getConvertedTags(acl.tags(), mapper)).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of("magpie.aws.discovery:NetworkAcl"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EC2::NetworkAcl", null, region, (SdkException)ex);
        }
    }

    private JsonNode getConvertedTags(List<Tag> tags, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(tags.stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }
}

