/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.LocationClientBuilder;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest;
import software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse;
import software.amazon.awssdk.services.location.model.DescribeMapRequest;
import software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest;
import software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest;
import software.amazon.awssdk.services.location.model.DescribeTrackerRequest;
import software.amazon.awssdk.services.location.model.DescribeTrackerResponse;
import software.amazon.awssdk.services.location.model.ListDevicePositionsRequest;
import software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry;
import software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest;
import software.amazon.awssdk.services.location.model.ListGeofenceResponseEntry;
import software.amazon.awssdk.services.location.model.ListGeofencesRequest;
import software.amazon.awssdk.services.location.model.ListMapsRequest;
import software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest;
import software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest;
import software.amazon.awssdk.services.location.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest;
import software.amazon.awssdk.services.location.model.ListTrackersRequest;

public class LocationDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "location";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return List.of(Region.AP_NORTHEAST_1, Region.AP_SOUTHEAST_1, Region.AP_SOUTHEAST_2, Region.EU_CENTRAL_1, Region.EU_WEST_1, Region.EU_NORTH_1, Region.US_EAST_1, Region.US_EAST_2, Region.US_WEST_2);
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (LocationClient client = (LocationClient)((LocationClientBuilder)clientCreator.apply(LocationClient.builder())).build();){
            this.discoverTrackers(mapper, session, region, emitter, account, client);
            this.discoverMaps(mapper, session, region, emitter, account, client);
            this.discoverGeofenceCollections(mapper, session, region, emitter, account, client);
            this.discoverPlaceIndex(mapper, session, region, emitter, account, client);
            this.discoverRouteCalculators(mapper, session, region, emitter, account, client);
        }
    }

    private void discoverTrackers(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, LocationClient client) {
        String RESOURCE_TYPE = "AWS::Location::Tracker";
        try {
            client.listTrackersPaginator((ListTrackersRequest)ListTrackersRequest.builder().build()).entries().stream().map(responseEntry -> client.describeTracker((DescribeTrackerRequest)DescribeTrackerRequest.builder().trackerName(responseEntry.trackerName()).build())).forEach(tracker -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, tracker.trackerArn()).withResourceName(tracker.trackerName()).withResourceType("AWS::Location::Tracker").withConfiguration(mapper.valueToTree((Object)tracker.toBuilder())).withCreatedIso(tracker.createTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverDevicePositions(client, (DescribeTrackerResponse)tracker, data);
                this.discoverTrackerConsumers(client, (DescribeTrackerResponse)tracker, data);
                this.discoverTags(client, tracker.trackerArn(), data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":tracker"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Location::Tracker", null, region, (SdkException)ex);
        }
    }

    private void discoverDevicePositions(LocationClient client, DescribeTrackerResponse tracker, MagpieAwsResource data) {
        String keyname = "devicePositions";
        AWSUtils.getAwsResponse(() -> client.listDevicePositionsPaginator((ListDevicePositionsRequest)ListDevicePositionsRequest.builder().trackerName(tracker.trackerName()).build()).entries().stream().map(ListDevicePositionsResponseEntry::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("devicePositions", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("devicePositions", noresp)));
    }

    private void discoverTrackerConsumers(LocationClient client, DescribeTrackerResponse tracker, MagpieAwsResource data) {
        String keyname = "trackerConsumers";
        AWSUtils.getAwsResponse(() -> client.listTrackerConsumersPaginator((ListTrackerConsumersRequest)ListTrackerConsumersRequest.builder().trackerName(tracker.trackerName()).build()).consumerArns().stream().collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("trackerConsumers", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("trackerConsumers", noresp)));
    }

    private void discoverMaps(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, LocationClient client) {
        String RESOURCE_TYPE = "AWS::Location::Map";
        try {
            client.listMapsPaginator((ListMapsRequest)ListMapsRequest.builder().build()).entries().stream().map(responseEntry -> client.describeMap((DescribeMapRequest)DescribeMapRequest.builder().mapName(responseEntry.mapName()).build())).forEach(map -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, map.mapArn()).withResourceName(map.mapName()).withResourceType("AWS::Location::Map").withConfiguration(mapper.valueToTree((Object)map.toBuilder())).withCreatedIso(map.createTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverTags(client, map.mapArn(), data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":map"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Location::Map", null, region, (SdkException)ex);
        }
    }

    private void discoverGeofenceCollections(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, LocationClient client) {
        String RESOURCE_TYPE = "AWS::Location::GeofenceCollection";
        try {
            client.listGeofenceCollectionsPaginator((ListGeofenceCollectionsRequest)ListGeofenceCollectionsRequest.builder().build()).entries().stream().map(responseEntry -> client.describeGeofenceCollection((DescribeGeofenceCollectionRequest)DescribeGeofenceCollectionRequest.builder().collectionName(responseEntry.collectionName()).build())).forEach(geofenceCollection -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, geofenceCollection.collectionArn()).withResourceName(geofenceCollection.collectionName()).withResourceType("AWS::Location::GeofenceCollection").withConfiguration(mapper.valueToTree((Object)geofenceCollection.toBuilder())).withCreatedIso(geofenceCollection.createTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverGeofences(client, (DescribeGeofenceCollectionResponse)geofenceCollection, data);
                this.discoverTags(client, geofenceCollection.collectionArn(), data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":geofenceCollection"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Location::GeofenceCollection", null, region, (SdkException)ex);
        }
    }

    private void discoverGeofences(LocationClient client, DescribeGeofenceCollectionResponse geofenceCollection, MagpieAwsResource data) {
        String keyname = "geofences";
        AWSUtils.getAwsResponse(() -> client.listGeofencesPaginator((ListGeofencesRequest)ListGeofencesRequest.builder().collectionName(geofenceCollection.collectionName()).build()).entries().stream().map(ListGeofenceResponseEntry::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("geofences", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("geofences", noresp)));
    }

    private void discoverPlaceIndex(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, LocationClient client) {
        String RESOURCE_TYPE = "AWS::Location::PlaceIndex";
        try {
            client.listPlaceIndexesPaginator((ListPlaceIndexesRequest)ListPlaceIndexesRequest.builder().build()).entries().stream().map(responseEntry -> client.describePlaceIndex((DescribePlaceIndexRequest)DescribePlaceIndexRequest.builder().indexName(responseEntry.indexName()).build())).forEach(placeIndex -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, placeIndex.indexArn()).withResourceName(placeIndex.indexName()).withResourceType("AWS::Location::PlaceIndex").withConfiguration(mapper.valueToTree((Object)placeIndex.toBuilder())).withCreatedIso(placeIndex.createTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverTags(client, placeIndex.indexArn(), data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":placeIndex"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Location::PlaceIndex", null, region, (SdkException)ex);
        }
    }

    private void discoverRouteCalculators(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, LocationClient client) {
        String RESOURCE_TYPE = "AWS::Location::RouteCalculator";
        try {
            client.listRouteCalculatorsPaginator((ListRouteCalculatorsRequest)ListRouteCalculatorsRequest.builder().build()).entries().stream().map(responseEntry -> client.describeRouteCalculator((DescribeRouteCalculatorRequest)DescribeRouteCalculatorRequest.builder().calculatorName(responseEntry.calculatorName()).build())).forEach(routeCalculator -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, routeCalculator.calculatorArn()).withResourceName(routeCalculator.calculatorName()).withResourceType("AWS::Location::RouteCalculator").withConfiguration(mapper.valueToTree((Object)routeCalculator.toBuilder())).withCreatedIso(routeCalculator.createTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverTags(client, routeCalculator.calculatorArn(), data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":routeCalculator"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Location::RouteCalculator", null, region, (SdkException)ex);
        }
    }

    private void discoverTags(LocationClient client, String arn, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceArn(arn).build()), resp -> {
            data.tags = mapper.valueToTree((Object)resp.tags());
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }
}

