/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.BatchClientBuilder;

public class BatchDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "batch";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return BatchClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (BatchClient client = (BatchClient)((BatchClientBuilder)clientCreator.apply(BatchClient.builder())).build();){
            this.discoverComputeEnvironments(mapper, session, client, region, emitter, account);
            this.discoverJobQueues(mapper, session, client, region, emitter, account);
            this.discoverJobDefinitions(mapper, session, client, region, emitter, account);
        }
    }

    private void discoverComputeEnvironments(ObjectMapper mapper, Session session, BatchClient client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::Batch::ComputeEnvironment";
        try {
            client.describeComputeEnvironmentsPaginator().computeEnvironments().forEach(computeEnvironment -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, computeEnvironment.computeEnvironmentArn()).withResourceName(computeEnvironment.computeEnvironmentName()).withResourceType("AWS::Batch::ComputeEnvironment").withConfiguration(mapper.valueToTree((Object)computeEnvironment.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":computeEnvironment"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Batch::ComputeEnvironment", null, region, (SdkException)ex);
        }
    }

    private void discoverJobQueues(ObjectMapper mapper, Session session, BatchClient client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::Batch::JobQueue";
        try {
            client.describeJobQueuesPaginator().jobQueues().forEach(jobQueue -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, jobQueue.jobQueueArn()).withResourceName(jobQueue.jobQueueName()).withResourceType("AWS::Batch::JobQueue").withConfiguration(mapper.valueToTree((Object)jobQueue.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":jobQueue"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Batch::JobQueue", null, region, (SdkException)ex);
        }
    }

    private void discoverJobDefinitions(ObjectMapper mapper, Session session, BatchClient client, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::Batch::JobDefinition";
        try {
            client.describeJobDefinitionsPaginator().jobDefinitions().forEach(jobDefinition -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, jobDefinition.jobDefinitionArn()).withResourceName(jobDefinition.jobDefinitionName()).withResourceType("AWS::Batch::JobDefinition").withConfiguration(mapper.valueToTree((Object)jobDefinition.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":jobDefinition"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Batch::JobDefinition", null, region, (SdkException)ex);
        }
    }
}

