/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.Conversions;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.FSxClientBuilder;
import software.amazon.awssdk.services.fsx.model.FileSystem;

public class FSXDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "fsx";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return FSxClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::FSx::FileSystem";
        try (FSxClient client = (FSxClient)((FSxClientBuilder)clientCreator.apply(FSxClient.builder())).build();){
            client.describeFileSystems().fileSystems().forEach(fileSystem -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, fileSystem.resourceARN()).withResourceName(fileSystem.fileSystemId()).withResourceId(fileSystem.fileSystemId()).withResourceType("AWS::FSx::FileSystem").withConfiguration(mapper.valueToTree((Object)fileSystem.toBuilder())).withCreatedIso(fileSystem.creationTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverSize((FileSystem)fileSystem, data, region, logger, clientCreator);
                this.discoverBackupJobs(fileSystem.resourceARN(), region, data, clientCreator, logger);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":fileSystem"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::FSx::FileSystem", null, region, (SdkException)ex);
        }
    }

    private void discoverSize(FileSystem resource, MagpieAwsResource data, Region region, Logger logger, MagpieAWSClientCreator clientCreator) {
        try {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("FileSystemId").value(resource.fileSystemId()).build());
            Pair<Long, GetMetricStatisticsResponse> freeStorageCapacity = AWSUtils.getCloudwatchMetricMinimum(region.toString(), "AWS/FSx", "FreeDataStorageCapacity", dimensions, clientCreator);
            long capacityAsBytes = Conversions.GibToBytes(resource.storageCapacity().intValue());
            data.sizeInBytes = capacityAsBytes - (Long)freeStorageCapacity.getValue0();
            data.maxSizeInBytes = capacityAsBytes;
            AWSUtils.update(data.supplementaryConfiguration, Map.of("freeDataStorageCapacity", freeStorageCapacity.getValue0()));
        }
        catch (Exception ex) {
            logger.debug("Failure on FSX size discovery, Region - {}; ResourceArn - {}", new Object[]{region, resource.resourceARN(), ex});
        }
    }
}

