/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.model.Tag;

public class CloudWatchDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "cloudWatch";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return CloudWatchClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (CloudWatchClient client = (CloudWatchClient)((CloudWatchClientBuilder)clientCreator.apply(CloudWatchClient.builder())).build();){
            this.discoverAlarms(mapper, session, region, emitter, client, account);
            this.discoverDashboards(mapper, session, region, emitter, client, account);
        }
    }

    private void discoverAlarms(ObjectMapper mapper, Session session, Region region, Emitter emitter, CloudWatchClient client, String account) {
        String RESOURCE_TYPE = "AWS::CloudWatch::Alarm";
        try {
            client.describeAlarmsPaginator().metricAlarms().stream().forEach(alarm -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, alarm.alarmArn()).withResourceName(alarm.alarmName()).withResourceType("AWS::CloudWatch::Alarm").withConfiguration(mapper.valueToTree((Object)alarm.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverAlarmHistory(client, (MetricAlarm)alarm, data);
                this.discoverAlarmTags(client, (MetricAlarm)alarm, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":alarm"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudWatch::Alarm", null, region, (SdkException)ex);
        }
    }

    private void discoverAlarmHistory(CloudWatchClient client, MetricAlarm resource, MagpieAwsResource data) {
        String keyname = "alarmHistory";
        AWSUtils.getAwsResponse(() -> client.describeAlarmHistoryPaginator((DescribeAlarmHistoryRequest)DescribeAlarmHistoryRequest.builder().alarmName(resource.alarmName()).build()).stream().map(DescribeAlarmHistoryResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("alarmHistory", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("alarmHistory", noresp)));
    }

    private void discoverAlarmTags(CloudWatchClient client, MetricAlarm resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceARN(resource.alarmArn()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }

    private void discoverDashboards(ObjectMapper mapper, Session session, Region region, Emitter emitter, CloudWatchClient client, String account) {
        String RESOURCE_TYPE = "AWS::CloudWatch::Dashboard";
        try {
            client.listDashboardsPaginator((ListDashboardsRequest)ListDashboardsRequest.builder().build()).dashboardEntries().stream().forEach(dashboard -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, dashboard.dashboardArn()).withResourceName(dashboard.dashboardName()).withResourceType("AWS::CloudWatch::Dashboard").withConfiguration(mapper.valueToTree((Object)dashboard.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":dashboard"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudWatch::Dashboard", null, region, (SdkException)ex);
        }
    }
}

