/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClientBuilder;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTag;
import software.amazon.awssdk.services.cloudtrail.model.Tag;
import software.amazon.awssdk.services.cloudtrail.model.TrailInfo;

public class CloudTrailDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "cloudTrail";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return CloudTrailClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::CloudTrail::Trail";
        try (CloudTrailClient client = (CloudTrailClient)((CloudTrailClientBuilder)clientCreator.apply(CloudTrailClient.builder())).build();){
            client.listTrailsPaginator((ListTrailsRequest)ListTrailsRequest.builder().build()).trails().forEach(trail -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, trail.trailARN()).withResourceName(trail.name()).withResourceType("AWS::CloudTrail::Trail").withConfiguration(mapper.valueToTree((Object)trail.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverEventSelectors(client, (TrailInfo)trail, data);
                this.discoverInsightSelectors(client, (TrailInfo)trail, data);
                this.discoverTrailDetails(client, (TrailInfo)trail, data);
                this.discoverTrailStatus(client, (TrailInfo)trail, data);
                this.discoverTags(client, (TrailInfo)trail, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":trail"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudTrail::Trail", null, region, (SdkException)ex);
        }
    }

    private void discoverEventSelectors(CloudTrailClient client, TrailInfo resource, MagpieAwsResource data) {
        String keyname = "eventSelectors";
        AWSUtils.getAwsResponse(() -> client.getEventSelectors((GetEventSelectorsRequest)GetEventSelectorsRequest.builder().trailName(resource.trailARN()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("eventSelectors", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("eventSelectors", noresp)));
    }

    private void discoverInsightSelectors(CloudTrailClient client, TrailInfo resource, MagpieAwsResource data) {
        String keyname = "insightSelectors";
        AWSUtils.getAwsResponse(() -> client.getInsightSelectors((GetInsightSelectorsRequest)GetInsightSelectorsRequest.builder().trailName(resource.trailARN()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("insightSelectors", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("insightSelectors", noresp)));
    }

    private void discoverTrailDetails(CloudTrailClient client, TrailInfo resource, MagpieAwsResource data) {
        String keyname = "trailDetails";
        AWSUtils.getAwsResponse(() -> client.getTrail((GetTrailRequest)GetTrailRequest.builder().name(resource.trailARN()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("trailDetails", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("trailDetails", noresp)));
    }

    private void discoverTrailStatus(CloudTrailClient client, TrailInfo resource, MagpieAwsResource data) {
        String keyname = "status";
        AWSUtils.getAwsResponse(() -> client.getTrailStatus((GetTrailStatusRequest)GetTrailStatusRequest.builder().name(resource.trailARN()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("status", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("status", noresp)));
    }

    private void discoverTags(CloudTrailClient client, TrailInfo resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsPaginator((ListTagsRequest)ListTagsRequest.builder().resourceIdList(new String[]{resource.trailARN()}).build()).resourceTagList().stream().findFirst(), resp -> {
            if (resp.isPresent()) {
                JsonNode tagsNode = (JsonNode)mapper.convertValue(((ResourceTag)resp.get()).tagsList().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
                AWSUtils.update(data.supplementaryConfiguration, tagsNode);
            }
        }, noresp -> AWSUtils.update(data.supplementaryConfiguration, noresp));
    }
}

