/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class ClientCreators {
    public static MagpieAWSClientCreator assumeRoleCreator(final Region region, final String roleArn, final Optional<String> externalIdOptional) {
        return new MagpieAWSClientCreator(){

            @Override
            public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT apply(AwsClientBuilder<BuilderT, ClientT> builder) {
                String magpieAwsEndpoint = System.getProperty("MAGPIE_AWS_ENDPOINT");
                if (magpieAwsEndpoint != null) {
                    builder.endpointOverride(URI.create(magpieAwsEndpoint));
                }
                AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(UUID.randomUUID().toString());
                externalIdOptional.ifPresent(arg_0 -> ((AssumeRoleRequest.Builder)assumeRoleRequestBuilder).externalId(arg_0));
                StsAssumeRoleCredentialsProvider provider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(StsClient.create())).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
                return (BuilderT)builder.credentialsProvider((AwsCredentialsProvider)provider).region(region);
            }
        };
    }

    public static MagpieAWSClientCreator localClientCreator(final Region region) {
        return new MagpieAWSClientCreator(){

            @Override
            public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT apply(AwsClientBuilder<BuilderT, ClientT> builder) {
                String magpieAwsEndpoint = System.getProperty("MAGPIE_AWS_ENDPOINT");
                if (magpieAwsEndpoint != null) {
                    builder.endpointOverride(URI.create(magpieAwsEndpoint));
                }
                return (BuilderT)builder.region(region);
            }
        };
    }
}

