/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;

public class ELBV2Discovery
implements AWSDiscovery {
    private static final String SERVICE = "elbv2";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return ElasticLoadBalancingV2Client.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::ElasticLoadBalancingV2::LoadBalancer";
        try (ElasticLoadBalancingV2Client client = (ElasticLoadBalancingV2Client)((ElasticLoadBalancingV2ClientBuilder)clientCreator.apply(ElasticLoadBalancingV2Client.builder())).build();){
            client.describeLoadBalancers().loadBalancers().forEach(loadBalancerV2 -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, loadBalancerV2.loadBalancerArn()).withResourceName(loadBalancerV2.dnsName()).withResourceId(loadBalancerV2.loadBalancerName()).withResourceType("AWS::ElasticLoadBalancingV2::LoadBalancer").withConfiguration(mapper.valueToTree((Object)loadBalancerV2.toBuilder())).withCreatedIso(loadBalancerV2.createdTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverAttributes(client, (LoadBalancer)loadBalancerV2, data, mapper);
                this.discoverTags(client, (LoadBalancer)loadBalancerV2, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":loadBalancerV2"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::ElasticLoadBalancingV2::LoadBalancer", null, region, (SdkException)ex);
        }
    }

    private void discoverAttributes(ElasticLoadBalancingV2Client client, LoadBalancer resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.describeLoadBalancerAttributes((DescribeLoadBalancerAttributesRequest)DescribeLoadBalancerAttributesRequest.builder().loadBalancerArn(resource.loadBalancerArn()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attributes", resp.toBuilder())), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attributes", noresp)));
    }

    private void discoverTags(ElasticLoadBalancingV2Client client, LoadBalancer resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.describeTags((DescribeTagsRequest)DescribeTagsRequest.builder().resourceArns(new String[]{resource.loadBalancerArn()}).build()).tagDescriptions(), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.stream().flatMap(tagDescription -> tagDescription.tags().stream()).collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }
}

