/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.aws.mcs.auth.SigV4AuthProvider;

public class CassandraDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "cassandra";
    private static final String RESOURCE_TYPE = "AWS::Cassandra::Keyspace";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Arrays.asList(Region.US_EAST_1, Region.US_EAST_2, Region.US_WEST_1, Region.US_WEST_2, Region.AP_EAST_1, Region.AP_SOUTH_1, Region.AP_NORTHEAST_1, Region.AP_NORTHEAST_2, Region.AP_SOUTHEAST_1, Region.AP_SOUTHEAST_2, Region.CA_CENTRAL_1, Region.CN_NORTH_1, Region.CN_NORTHWEST_1, Region.EU_CENTRAL_1, Region.EU_WEST_1, Region.EU_WEST_2, Region.EU_WEST_3, Region.EU_NORTH_1, Region.SA_EAST_1);
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        List<InetSocketAddress> contactPoints = Collections.singletonList(InetSocketAddress.createUnresolved(String.format("cassandra.%s.amazonaws.com", region), 9142));
        try {
            try {
                SSLContext sslContext = SSLContext.getDefault();
                try (CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoints(contactPoints)).withSslContext(sslContext)).withLocalDatacenter(region.id())).withAuthProvider((AuthProvider)new SigV4AuthProvider(region.id()))).build();){
                    this.doRun(region, cqlSession, emitter, logger, mapper, session, account);
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("NoSuchAlgorithmException when getting SSLContext");
            }
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException(RESOURCE_TYPE, null, region, (SdkException)ex);
        }
    }

    private void doRun(Region region, CqlSession cqlSession, Emitter emitter, Logger logger, ObjectMapper mapper, Session session, String account) {
        ResultSet keyspaces = cqlSession.execute("select * from system_schema.keyspaces");
        keyspaces.forEach(keyspace -> {
            try {
                String keyspaceName = keyspace.getString("keyspace_name");
                String arn = String.format("arn:aws:cassandra:keyspace:%s::%s", region, keyspaceName);
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(keyspaceName).withResourceId(keyspaceName).withResourceType(RESOURCE_TYPE).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverTables(cqlSession, keyspaceName, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":keyspace"), data.toJsonNode()));
            }
            catch (Exception ex) {
                DiscoveryExceptions.onDiscoveryException(RESOURCE_TYPE, null, region, ex);
            }
        });
    }

    private void discoverTables(CqlSession session, String keyspaceName, MagpieAwsResource data) {
        ArrayList tables = new ArrayList();
        String tablesQuery = String.format("SELECT keyspace_name, table_name, status FROM system_schema_mcs.tables WHERE keyspace_name = '%s'", keyspaceName);
        session.execute(tablesQuery).forEach(table -> tables.add(table.getString("table_name")));
        AWSUtils.update(data.supplementaryConfiguration, Map.of("Tables", tables));
    }
}

