/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.Tag;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DynamoDbDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "dynamoDb";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return DynamoDbClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (DynamoDbClient client = (DynamoDbClient)((DynamoDbClientBuilder)clientCreator.apply(DynamoDbClient.builder())).build();){
            this.discoverGlobalTables(mapper, session, region, emitter, client, account);
            this.discoverTables(mapper, session, region, emitter, client, account, clientCreator, logger);
        }
    }

    protected void discoverGlobalTables(ObjectMapper mapper, Session session, Region region, Emitter emitter, DynamoDbClient client, String account) {
        String RESOURCE_TYPE = "AWS::DynamoDB::GlobalTable";
        try {
            client.listGlobalTables().globalTables().stream().map(globalTable -> client.describeGlobalTable((DescribeGlobalTableRequest)DescribeGlobalTableRequest.builder().globalTableName(globalTable.globalTableName()).build()).globalTableDescription()).forEach(globalTable -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, globalTable.globalTableArn()).withResourceName(globalTable.globalTableName()).withResourceType("AWS::DynamoDB::GlobalTable").withConfiguration(mapper.valueToTree((Object)globalTable.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":globalTable"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::DynamoDB::GlobalTable", null, region, (SdkException)ex);
        }
    }

    protected void discoverTables(ObjectMapper mapper, Session session, Region region, Emitter emitter, DynamoDbClient client, String account, MagpieAWSClientCreator clientCreator, Logger logger) {
        String RESOURCE_TYPE = "AWS::DynamoDB::Table";
        try {
            client.listTablesPaginator().tableNames().stream().map(tableName -> client.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build()).table()).forEach(table -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, table.tableArn()).withResourceName(table.tableName()).withResourceId(table.tableId()).withResourceType("AWS::DynamoDB::Table").withConfiguration(mapper.valueToTree((Object)table.toBuilder())).withCreatedIso(table.creationDateTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverSize(data);
                this.discoverContinuousBackups(client, (TableDescription)table, data);
                this.discoverTags(client, (TableDescription)table, data, mapper);
                this.discoverBackupJobs(table.tableArn(), region, data, clientCreator, logger);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":table"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::DynamoDB::Table", null, region, (SdkException)ex);
        }
    }

    private void discoverSize(MagpieAwsResource data) {
        JsonNode sizeNode = data.configuration.at("/tableSizeBytes");
        if (!sizeNode.isMissingNode()) {
            data.sizeInBytes = sizeNode.asLong();
        }
    }

    private void discoverContinuousBackups(DynamoDbClient client, TableDescription resource, MagpieAwsResource data) {
        AWSUtils.getAwsResponse(() -> client.describeContinuousBackups(builder -> builder.tableName(resource.tableName())), resp -> AWSUtils.update(data.supplementaryConfiguration, new ToCopyableBuilder[]{resp}), noresp -> AWSUtils.update(data.supplementaryConfiguration, noresp));
    }

    private void discoverTags(DynamoDbClient client, TableDescription resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsOfResource((ListTagsOfResourceRequest)ListTagsOfResourceRequest.builder().resourceArn(resource.tableArn()).build()), resp -> AWSUtils.update(data.tags, (JsonNode)mapper.convertValue(resp.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class)), noresp -> AWSUtils.update(data.tags, noresp));
    }
}

