/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;

public class LambdaDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "lambda";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return LambdaClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Lambda::Function";
        try (LambdaClient client = (LambdaClient)((LambdaClientBuilder)clientCreator.apply(LambdaClient.builder())).build();){
            client.listFunctionsPaginator().functions().forEach(function -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, function.functionArn()).withResourceName(function.functionName()).withResourceId(function.revisionId()).withResourceType("AWS::Lambda::Function").withConfiguration(mapper.valueToTree((Object)function.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverFunctionEventInvokeConfigs(client, (FunctionConfiguration)function, data);
                this.discoverEventSourceMapping(client, (FunctionConfiguration)function, data);
                this.discoverFunction(client, (FunctionConfiguration)function, data);
                this.discoverFunctionInvokeConfig(client, (FunctionConfiguration)function, data);
                this.discoverAccessPolicy(client, (FunctionConfiguration)function, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":function"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Lambda::Function", null, region, (SdkException)ex);
        }
    }

    private void discoverFunctionEventInvokeConfigs(LambdaClient client, FunctionConfiguration resource, MagpieAwsResource data) {
        String keyname = "functionEventInvokeConfigs";
        AWSUtils.getAwsResponse(() -> client.listFunctionEventInvokeConfigsPaginator((ListFunctionEventInvokeConfigsRequest)ListFunctionEventInvokeConfigsRequest.builder().functionName(resource.functionName()).build()).functionEventInvokeConfigs().stream().map(FunctionEventInvokeConfig::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("functionEventInvokeConfigs", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("functionEventInvokeConfigs", noresp)));
    }

    private void discoverEventSourceMapping(LambdaClient client, FunctionConfiguration resource, MagpieAwsResource data) {
        String keyname = "eventSourceMapping";
        AWSUtils.getAwsResponse(() -> client.listEventSourceMappingsPaginator((ListEventSourceMappingsRequest)ListEventSourceMappingsRequest.builder().functionName(resource.functionName()).build()).eventSourceMappings().stream().map(EventSourceMappingConfiguration::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("eventSourceMapping", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("eventSourceMapping", noresp)));
    }

    private void discoverFunctionInvokeConfig(LambdaClient client, FunctionConfiguration resource, MagpieAwsResource data) {
        String keyname = "functionInvokeConfig";
        AWSUtils.getAwsResponse(() -> client.getFunctionEventInvokeConfig((GetFunctionEventInvokeConfigRequest)GetFunctionEventInvokeConfigRequest.builder().functionName(resource.functionName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("functionInvokeConfig", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("functionInvokeConfig", noresp)));
    }

    private void discoverFunction(LambdaClient client, FunctionConfiguration resource, MagpieAwsResource data) {
        String keyname = "function";
        AWSUtils.getAwsResponse(() -> client.getFunction((GetFunctionRequest)GetFunctionRequest.builder().functionName(resource.functionName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("function", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("function", noresp)));
    }

    private void discoverAccessPolicy(LambdaClient client, FunctionConfiguration resource, MagpieAwsResource data) {
        String keyname = "accessPolicy";
        AWSUtils.getAwsResponse(() -> client.getPolicy((GetPolicyRequest)GetPolicyRequest.builder().functionName(resource.functionName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("accessPolicy", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("accessPolicy", noresp)));
    }
}

