/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.ElastiCacheClientBuilder;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;

public class ElastiCacheDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "elastiCache";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return ElastiCacheClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::ElastiCache::Cluster";
        try (ElastiCacheClient client = (ElastiCacheClient)((ElastiCacheClientBuilder)clientCreator.apply(ElastiCacheClient.builder())).build();){
            client.describeCacheClusters().cacheClusters().forEach(cacheCluster -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, cacheCluster.arn()).withResourceName(cacheCluster.cacheClusterId()).withResourceId(cacheCluster.cacheClusterId()).withResourceType("AWS::ElastiCache::Cluster").withConfiguration(mapper.valueToTree((Object)cacheCluster.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverRedisSize((CacheCluster)cacheCluster, data, region.id(), clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":cacheCluster"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::ElastiCache::Cluster", null, region, (SdkException)ex);
        }
    }

    private void discoverRedisSize(CacheCluster resource, MagpieAwsResource data, String region, MagpieAWSClientCreator clientCreator) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add((Dimension)Dimension.builder().name("CacheClusterId").value(resource.cacheClusterId()).build());
        Pair<Long, GetMetricStatisticsResponse> volumeBytesUsed = AWSUtils.getCloudwatchMetricMaximum(region, "AWS/ElastiCache", "BytesUsedForCache", dimensions, clientCreator);
        Pair<Double, GetMetricStatisticsResponse> DatabaseMemoryUsagePercentage = AWSUtils.getCloudwatchDoubleMetricMaximum(region, "AWS/ElastiCache", "DatabaseMemoryUsagePercentage", dimensions, clientCreator);
        if (volumeBytesUsed.getValue0() != null) {
            AWSUtils.update(data.supplementaryConfiguration, Map.of("bytesUsedForCache", volumeBytesUsed.getValue0(), "databaseMemoryUsagePercentage", DatabaseMemoryUsagePercentage.getValue0(), "databaseMaxSize", (long)((double)((Long)volumeBytesUsed.getValue0()).longValue() / ((Double)DatabaseMemoryUsagePercentage.getValue0() / 100.0))));
        }
    }
}

