/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;

public class SecretsManagerDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "secretsManager";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return SecretsManagerClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::SecretsManager";
        try (SecretsManagerClient client = (SecretsManagerClient)((SecretsManagerClientBuilder)clientCreator.apply(SecretsManagerClient.builder())).build();){
            client.listSecretsPaginator((ListSecretsRequest)ListSecretsRequest.builder().build()).stream().forEach(secretsPaginatedResponse -> secretsPaginatedResponse.secretList().stream().map(secretListEntry -> client.describeSecret((DescribeSecretRequest)DescribeSecretRequest.builder().secretId(secretListEntry.arn()).build())).forEach(secret -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, secret.arn()).withResourceName(secret.name()).withResourceType("AWS::SecretsManager").withConfiguration(mapper.valueToTree((Object)secret.toBuilder())).withCreatedIso(secret.createdDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":secret"), data.toJsonNode()));
            }));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::SecretsManager", null, region, (SdkException)ex);
        }
    }
}

