/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ResourceInfo;

public class LakeFormationDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "lakeFormation";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return LakeFormationClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::LakeFormation::Resource";
        try (LakeFormationClient client = (LakeFormationClient)((LakeFormationClientBuilder)clientCreator.apply(LakeFormationClient.builder())).build();){
            client.listResourcesPaginator((ListResourcesRequest)ListResourcesRequest.builder().build()).stream().forEach(list -> list.resourceInfoList().forEach(resourceInfo -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, resourceInfo.resourceArn()).withResourceType("AWS::LakeFormation::Resource").withConfiguration(mapper.valueToTree((Object)resourceInfo.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverDataLakeSettings(client, data);
                this.discoverPermissions(client, (ResourceInfo)resourceInfo, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":resource"), data.toJsonNode()));
            }));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::LakeFormation::Resource", null, region, (SdkException)ex);
        }
    }

    private void discoverDataLakeSettings(LakeFormationClient client, MagpieAwsResource data) {
        String keyname = "dataLakeSettings";
        AWSUtils.getAwsResponse(() -> client.getDataLakeSettings((GetDataLakeSettingsRequest)GetDataLakeSettingsRequest.builder().build()).dataLakeSettings(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("dataLakeSettings", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("dataLakeSettings", noresp)));
    }

    private void discoverPermissions(LakeFormationClient client, ResourceInfo resource, MagpieAwsResource data) {
        String keyname = "permissions";
        AWSUtils.getAwsResponse(() -> client.getEffectivePermissionsForPath((GetEffectivePermissionsForPathRequest)GetEffectivePermissionsForPathRequest.builder().resourceArn(resource.resourceArn()).build()).permissions(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("permissions", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("permissions", noresp)));
    }
}

