/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaClientBuilder;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;

public class AthenaDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "athena";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return AthenaClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Athena::DataCatalog";
        try (AthenaClient client = (AthenaClient)((AthenaClientBuilder)clientCreator.apply(AthenaClient.builder())).build();){
            client.listDataCatalogsPaginator((ListDataCatalogsRequest)ListDataCatalogsRequest.builder().build()).dataCatalogsSummary().forEach(dataCatalog -> {
                String arn = String.format("arn:aws:athena:%s:%s:datacatalog/%s", region, account, dataCatalog.catalogName());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(dataCatalog.catalogName()).withResourceType("AWS::Athena::DataCatalog").withConfiguration(mapper.valueToTree((Object)dataCatalog.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverDatabases(client, (DataCatalogSummary)dataCatalog, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":dataCatalog"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Athena::DataCatalog", null, region, (SdkException)ex);
        }
    }

    private void discoverDatabases(AthenaClient client, DataCatalogSummary resource, MagpieAwsResource data) {
        String keyname = "databases";
        AWSUtils.getAwsResponse(() -> client.listDatabasesPaginator((ListDatabasesRequest)ListDatabasesRequest.builder().catalogName(resource.catalogName()).build()).stream().map(ListDatabasesResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("databases", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("databases", noresp)));
    }
}

