/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.EfsClientBuilder;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;

public class EFSDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "efs";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return EfsClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::EFS::FileSystem";
        try (EfsClient client = (EfsClient)((EfsClientBuilder)clientCreator.apply(EfsClient.builder())).build();){
            client.describeFileSystems().fileSystems().forEach(fileSystem -> {
                String arn = String.format("arn:aws:elasticfilesystem:%s:%s:file-system/%s", region, fileSystem.ownerId(), fileSystem.fileSystemId());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(fileSystem.name()).withResourceId(fileSystem.fileSystemId()).withResourceType("AWS::EFS::FileSystem").withConfiguration(mapper.valueToTree((Object)fileSystem.toBuilder())).withCreatedIso(fileSystem.creationTime()).withSizeInBytes(fileSystem.sizeInBytes().value()).withAccountId(fileSystem.ownerId()).withAwsRegion(region.toString()).build();
                this.discoverMountTargets(client, (FileSystemDescription)fileSystem, data);
                this.discoverBackupJobs(arn, region, data, clientCreator, logger);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":fileSystem"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EFS::FileSystem", null, region, (SdkException)ex);
        }
    }

    private void discoverMountTargets(EfsClient client, FileSystemDescription resource, MagpieAwsResource data) {
        String keyname = "mountTargets";
        AWSUtils.getAwsResponse(() -> client.describeMountTargets((DescribeMountTargetsRequest)DescribeMountTargetsRequest.builder().fileSystemId(resource.fileSystemId()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("mountTargets", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("mountTargets", noresp)));
    }
}

